/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetLicenseDefinitionRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseDefinitionsRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseToggleRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseUserRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseUsersRequest;
import com.mypurecloud.sdk.v2.api.request.PostLicenseInferRequest;
import com.mypurecloud.sdk.v2.api.request.PostLicenseOrganizationRequest;
import com.mypurecloud.sdk.v2.api.request.PostLicenseToggleRequest;
import com.mypurecloud.sdk.v2.api.request.PostLicenseUsersRequest;
import com.mypurecloud.sdk.v2.model.LicenseBatchAssignmentRequest;
import com.mypurecloud.sdk.v2.model.LicenseDefinition;
import com.mypurecloud.sdk.v2.model.LicenseOrgToggle;
import com.mypurecloud.sdk.v2.model.LicenseUpdateStatus;
import com.mypurecloud.sdk.v2.model.LicenseUser;
import com.mypurecloud.sdk.v2.model.UserLicensesEntityListing;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class LicenseApi {
    private final ApiClient pcapiClient;

    public LicenseApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LicenseApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public LicenseDefinition getLicenseDefinition(String licenseId) throws IOException, ApiException {
        return this.getLicenseDefinition(this.createGetLicenseDefinitionRequest(licenseId));
    }

    public ApiResponse<LicenseDefinition> getLicenseDefinitionWithHttpInfo(String licenseId) throws IOException {
        return this.getLicenseDefinition(this.createGetLicenseDefinitionRequest(licenseId).withHttpInfo());
    }

    private GetLicenseDefinitionRequest createGetLicenseDefinitionRequest(String licenseId) {
        return GetLicenseDefinitionRequest.builder().withLicenseId(licenseId).build();
    }

    public LicenseDefinition getLicenseDefinition(GetLicenseDefinitionRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LicenseDefinition> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LicenseDefinition>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LicenseDefinition> getLicenseDefinition(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LicenseDefinition>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public List<LicenseDefinition> getLicenseDefinitions() throws IOException, ApiException {
        return this.getLicenseDefinitions(this.createGetLicenseDefinitionsRequest());
    }

    public ApiResponse<List<LicenseDefinition>> getLicenseDefinitionsWithHttpInfo() throws IOException {
        return this.getLicenseDefinitions(this.createGetLicenseDefinitionsRequest().withHttpInfo());
    }

    private GetLicenseDefinitionsRequest createGetLicenseDefinitionsRequest() {
        return GetLicenseDefinitionsRequest.builder().build();
    }

    public List<LicenseDefinition> getLicenseDefinitions(GetLicenseDefinitionsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<List<LicenseDefinition>> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<List<LicenseDefinition>>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<List<LicenseDefinition>> getLicenseDefinitions(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<List<LicenseDefinition>>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LicenseOrgToggle getLicenseToggle(String featureName) throws IOException, ApiException {
        return this.getLicenseToggle(this.createGetLicenseToggleRequest(featureName));
    }

    public ApiResponse<LicenseOrgToggle> getLicenseToggleWithHttpInfo(String featureName) throws IOException {
        return this.getLicenseToggle(this.createGetLicenseToggleRequest(featureName).withHttpInfo());
    }

    private GetLicenseToggleRequest createGetLicenseToggleRequest(String featureName) {
        return GetLicenseToggleRequest.builder().withFeatureName(featureName).build();
    }

    public LicenseOrgToggle getLicenseToggle(GetLicenseToggleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LicenseOrgToggle> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LicenseOrgToggle>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LicenseOrgToggle> getLicenseToggle(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LicenseOrgToggle>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LicenseUser getLicenseUser(String userId) throws IOException, ApiException {
        return this.getLicenseUser(this.createGetLicenseUserRequest(userId));
    }

    public ApiResponse<LicenseUser> getLicenseUserWithHttpInfo(String userId) throws IOException {
        return this.getLicenseUser(this.createGetLicenseUserRequest(userId).withHttpInfo());
    }

    private GetLicenseUserRequest createGetLicenseUserRequest(String userId) {
        return GetLicenseUserRequest.builder().withUserId(userId).build();
    }

    public LicenseUser getLicenseUser(GetLicenseUserRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LicenseUser> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LicenseUser>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LicenseUser> getLicenseUser(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LicenseUser>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UserLicensesEntityListing getLicenseUsers(Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        return this.getLicenseUsers(this.createGetLicenseUsersRequest(pageSize, pageNumber));
    }

    public ApiResponse<UserLicensesEntityListing> getLicenseUsersWithHttpInfo(Integer pageSize, Integer pageNumber) throws IOException {
        return this.getLicenseUsers(this.createGetLicenseUsersRequest(pageSize, pageNumber).withHttpInfo());
    }

    private GetLicenseUsersRequest createGetLicenseUsersRequest(Integer pageSize, Integer pageNumber) {
        return GetLicenseUsersRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).build();
    }

    public UserLicensesEntityListing getLicenseUsers(GetLicenseUsersRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UserLicensesEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UserLicensesEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UserLicensesEntityListing> getLicenseUsers(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UserLicensesEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public List<String> postLicenseInfer(List<String> body) throws IOException, ApiException {
        return this.postLicenseInfer(this.createPostLicenseInferRequest(body));
    }

    public ApiResponse<List<String>> postLicenseInferWithHttpInfo(List<String> body) throws IOException {
        return this.postLicenseInfer(this.createPostLicenseInferRequest(body).withHttpInfo());
    }

    private PostLicenseInferRequest createPostLicenseInferRequest(List<String> body) {
        return PostLicenseInferRequest.builder().withBody(body).build();
    }

    public List<String> postLicenseInfer(PostLicenseInferRequest request) throws IOException, ApiException {
        try {
            ApiResponse<List<String>> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<List<String>>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<List<String>> postLicenseInfer(ApiRequest<List<String>> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<List<String>>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public List<LicenseUpdateStatus> postLicenseOrganization(LicenseBatchAssignmentRequest body) throws IOException, ApiException {
        return this.postLicenseOrganization(this.createPostLicenseOrganizationRequest(body));
    }

    public ApiResponse<List<LicenseUpdateStatus>> postLicenseOrganizationWithHttpInfo(LicenseBatchAssignmentRequest body) throws IOException {
        return this.postLicenseOrganization(this.createPostLicenseOrganizationRequest(body).withHttpInfo());
    }

    private PostLicenseOrganizationRequest createPostLicenseOrganizationRequest(LicenseBatchAssignmentRequest body) {
        return PostLicenseOrganizationRequest.builder().withBody(body).build();
    }

    public List<LicenseUpdateStatus> postLicenseOrganization(PostLicenseOrganizationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<List<LicenseUpdateStatus>> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<List<LicenseUpdateStatus>>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<List<LicenseUpdateStatus>> postLicenseOrganization(ApiRequest<LicenseBatchAssignmentRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<List<LicenseUpdateStatus>>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LicenseOrgToggle postLicenseToggle(String featureName) throws IOException, ApiException {
        return this.postLicenseToggle(this.createPostLicenseToggleRequest(featureName));
    }

    public ApiResponse<LicenseOrgToggle> postLicenseToggleWithHttpInfo(String featureName) throws IOException {
        return this.postLicenseToggle(this.createPostLicenseToggleRequest(featureName).withHttpInfo());
    }

    private PostLicenseToggleRequest createPostLicenseToggleRequest(String featureName) {
        return PostLicenseToggleRequest.builder().withFeatureName(featureName).build();
    }

    public LicenseOrgToggle postLicenseToggle(PostLicenseToggleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LicenseOrgToggle> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LicenseOrgToggle>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LicenseOrgToggle> postLicenseToggle(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LicenseOrgToggle>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Map<String, Object> postLicenseUsers(List<String> body) throws IOException, ApiException {
        return this.postLicenseUsers(this.createPostLicenseUsersRequest(body));
    }

    public ApiResponse<Map<String, Object>> postLicenseUsersWithHttpInfo(List<String> body) throws IOException {
        return this.postLicenseUsers(this.createPostLicenseUsersRequest(body).withHttpInfo());
    }

    private PostLicenseUsersRequest createPostLicenseUsersRequest(List<String> body) {
        return PostLicenseUsersRequest.builder().withBody(body).build();
    }

    public Map<String, Object> postLicenseUsers(PostLicenseUsersRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Map<String, Object>> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Map<String, Object>>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Map<String, Object>> postLicenseUsers(ApiRequest<List<String>> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Map<String, Object>>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

