/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class TimeOffRequestNotification
implements Serializable {
    private String timeOffRequestId = null;
    private UserReference user = null;
    private Boolean isFullDayRequest = null;
    private StatusEnum status = null;
    private List<Date> partialDayStartDateTimes = new ArrayList<Date>();
    private List<String> fullDayManagementUnitDates = new ArrayList<String>();

    public TimeOffRequestNotification timeOffRequestId(String timeOffRequestId) {
        this.timeOffRequestId = timeOffRequestId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of this time off request")
    @JsonProperty(value="timeOffRequestId")
    public String getTimeOffRequestId() {
        return this.timeOffRequestId;
    }

    public void setTimeOffRequestId(String timeOffRequestId) {
        this.timeOffRequestId = timeOffRequestId;
    }

    public TimeOffRequestNotification user(UserReference user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The user associated with this time off request")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    public void setUser(UserReference user) {
        this.user = user;
    }

    public TimeOffRequestNotification isFullDayRequest(Boolean isFullDayRequest) {
        this.isFullDayRequest = isFullDayRequest;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this is a full day request (false means partial day)")
    @JsonProperty(value="isFullDayRequest")
    public Boolean getIsFullDayRequest() {
        return this.isFullDayRequest;
    }

    public void setIsFullDayRequest(Boolean isFullDayRequest) {
        this.isFullDayRequest = isFullDayRequest;
    }

    public TimeOffRequestNotification status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of this time off request")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TimeOffRequestNotification partialDayStartDateTimes(List<Date> partialDayStartDateTimes) {
        this.partialDayStartDateTimes = partialDayStartDateTimes;
        return this;
    }

    @ApiModelProperty(example="null", value="A set of start date-times in ISO-8601 format for partial day requests.  Will be not empty if isFullDayRequest == false")
    @JsonProperty(value="partialDayStartDateTimes")
    public List<Date> getPartialDayStartDateTimes() {
        return this.partialDayStartDateTimes;
    }

    public void setPartialDayStartDateTimes(List<Date> partialDayStartDateTimes) {
        this.partialDayStartDateTimes = partialDayStartDateTimes;
    }

    public TimeOffRequestNotification fullDayManagementUnitDates(List<String> fullDayManagementUnitDates) {
        this.fullDayManagementUnitDates = fullDayManagementUnitDates;
        return this;
    }

    @ApiModelProperty(example="null", value="A set of dates in yyyy-MM-dd format.  Should be interpreted in the management unit's configured time zone.  Will be not empty if isFullDayRequest == true")
    @JsonProperty(value="fullDayManagementUnitDates")
    public List<String> getFullDayManagementUnitDates() {
        return this.fullDayManagementUnitDates;
    }

    public void setFullDayManagementUnitDates(List<String> fullDayManagementUnitDates) {
        this.fullDayManagementUnitDates = fullDayManagementUnitDates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeOffRequestNotification timeOffRequestNotification = (TimeOffRequestNotification)o;
        return Objects.equals(this.timeOffRequestId, timeOffRequestNotification.timeOffRequestId) && Objects.equals(this.user, timeOffRequestNotification.user) && Objects.equals(this.isFullDayRequest, timeOffRequestNotification.isFullDayRequest) && Objects.equals((Object)this.status, (Object)timeOffRequestNotification.status) && Objects.equals(this.partialDayStartDateTimes, timeOffRequestNotification.partialDayStartDateTimes) && Objects.equals(this.fullDayManagementUnitDates, timeOffRequestNotification.fullDayManagementUnitDates);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timeOffRequestId, this.user, this.isFullDayRequest, this.status, this.partialDayStartDateTimes, this.fullDayManagementUnitDates});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeOffRequestNotification {\n");
        sb.append("    timeOffRequestId: ").append(this.toIndentedString(this.timeOffRequestId)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    isFullDayRequest: ").append(this.toIndentedString(this.isFullDayRequest)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    partialDayStartDateTimes: ").append(this.toIndentedString(this.partialDayStartDateTimes)).append("\n");
        sb.append("    fullDayManagementUnitDates: ").append(this.toIndentedString(this.fullDayManagementUnitDates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("PENDING"),
        APPROVED("APPROVED"),
        DENIED("DENIED"),
        CANCELED("CANCELED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

