/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A complex type that defines service provider attributes or subattributes and their qualities.")
public class ScimV2SchemaAttribute
implements Serializable {
    private String name = null;
    private TypeEnum type = null;
    private List<ScimV2SchemaAttribute> subAttributes = new ArrayList<ScimV2SchemaAttribute>();
    private Boolean multiValued = null;
    private String description = null;
    private Boolean required = null;
    private List<String> canonicalValues = new ArrayList<String>();
    private Boolean caseExact = null;
    private MutabilityEnum mutability = null;
    private ReturnedEnum returned = null;
    private UniquenessEnum uniqueness = null;
    private List<ReferenceTypesEnum> referenceTypes = new ArrayList<ReferenceTypesEnum>();

    @ApiModelProperty(example="null", value="The name of the attribute.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="The data type of the attribute.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public ScimV2SchemaAttribute subAttributes(List<ScimV2SchemaAttribute> subAttributes) {
        this.subAttributes = subAttributes;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of subattributes for an attribute of the type \"complex\". Uses the same schema as \"attributes\".")
    @JsonProperty(value="subAttributes")
    public List<ScimV2SchemaAttribute> getSubAttributes() {
        return this.subAttributes;
    }

    public void setSubAttributes(List<ScimV2SchemaAttribute> subAttributes) {
        this.subAttributes = subAttributes;
    }

    @ApiModelProperty(example="null", value="Indicates whether an attribute contains multiple values.")
    @JsonProperty(value="multiValued")
    public Boolean getMultiValued() {
        return this.multiValued;
    }

    @ApiModelProperty(example="null", value="The description of the attribute.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(example="null", value="Indicates whether an attribute is required.")
    @JsonProperty(value="required")
    public Boolean getRequired() {
        return this.required;
    }

    public ScimV2SchemaAttribute canonicalValues(List<String> canonicalValues) {
        this.canonicalValues = canonicalValues;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of standard values that service providers may use. Service providers may ignore unsupported values.")
    @JsonProperty(value="canonicalValues")
    public List<String> getCanonicalValues() {
        return this.canonicalValues;
    }

    public void setCanonicalValues(List<String> canonicalValues) {
        this.canonicalValues = canonicalValues;
    }

    @ApiModelProperty(example="null", value="Indicates whether a string attribute is case-sensitive. If set to \"true\", the server preserves case sensitivity. If set to \"false\", the server may change the case. The server also uses case sensitivity when evaluating filters. See section 3.4.2.2 \"Filtering\" in RFC 7644 for details.")
    @JsonProperty(value="caseExact")
    public Boolean getCaseExact() {
        return this.caseExact;
    }

    @ApiModelProperty(example="null", value="The circumstances under which an attribute can be defined or redefined. The default is \"readWrite\".")
    @JsonProperty(value="mutability")
    public MutabilityEnum getMutability() {
        return this.mutability;
    }

    @ApiModelProperty(example="null", value="The circumstances under which an attribute and its values are returned in response to a GET, PUT, POST, or PATCH request.")
    @JsonProperty(value="returned")
    public ReturnedEnum getReturned() {
        return this.returned;
    }

    @ApiModelProperty(example="null", value="The method by which the service provider enforces the uniqueness of an attribute value. A server can reject a value by returning the HTTP response code 400 (Bad Request). A client can enforce uniqueness to a greater degree than the server provider enforces. For example, a client could make a value unique even though the server has \"uniqueness\" set to \"none\".")
    @JsonProperty(value="uniqueness")
    public UniquenessEnum getUniqueness() {
        return this.uniqueness;
    }

    public ScimV2SchemaAttribute referenceTypes(List<ReferenceTypesEnum> referenceTypes) {
        this.referenceTypes = referenceTypes;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of SCIM resource types that may be referenced. Only applies when \"type\" is set to \"reference\".")
    @JsonProperty(value="referenceTypes")
    public List<ReferenceTypesEnum> getReferenceTypes() {
        return this.referenceTypes;
    }

    public void setReferenceTypes(List<ReferenceTypesEnum> referenceTypes) {
        this.referenceTypes = referenceTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimV2SchemaAttribute scimV2SchemaAttribute = (ScimV2SchemaAttribute)o;
        return Objects.equals(this.name, scimV2SchemaAttribute.name) && Objects.equals((Object)this.type, (Object)scimV2SchemaAttribute.type) && Objects.equals(this.subAttributes, scimV2SchemaAttribute.subAttributes) && Objects.equals(this.multiValued, scimV2SchemaAttribute.multiValued) && Objects.equals(this.description, scimV2SchemaAttribute.description) && Objects.equals(this.required, scimV2SchemaAttribute.required) && Objects.equals(this.canonicalValues, scimV2SchemaAttribute.canonicalValues) && Objects.equals(this.caseExact, scimV2SchemaAttribute.caseExact) && Objects.equals((Object)this.mutability, (Object)scimV2SchemaAttribute.mutability) && Objects.equals((Object)this.returned, (Object)scimV2SchemaAttribute.returned) && Objects.equals((Object)this.uniqueness, (Object)scimV2SchemaAttribute.uniqueness) && Objects.equals(this.referenceTypes, scimV2SchemaAttribute.referenceTypes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.subAttributes, this.multiValued, this.description, this.required, this.canonicalValues, this.caseExact, this.mutability, this.returned, this.uniqueness, this.referenceTypes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimV2SchemaAttribute {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    subAttributes: ").append(this.toIndentedString(this.subAttributes)).append("\n");
        sb.append("    multiValued: ").append(this.toIndentedString(this.multiValued)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    canonicalValues: ").append(this.toIndentedString(this.canonicalValues)).append("\n");
        sb.append("    caseExact: ").append(this.toIndentedString(this.caseExact)).append("\n");
        sb.append("    mutability: ").append(this.toIndentedString((Object)this.mutability)).append("\n");
        sb.append("    returned: ").append(this.toIndentedString((Object)this.returned)).append("\n");
        sb.append("    uniqueness: ").append(this.toIndentedString((Object)this.uniqueness)).append("\n");
        sb.append("    referenceTypes: ").append(this.toIndentedString(this.referenceTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ReferenceTypesEnumDeserializer.class)
    public static enum ReferenceTypesEnum {
        USER("User"),
        GROUP("Group"),
        EXTERNAL("external"),
        URI("uri");

        private String value;

        private ReferenceTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ReferenceTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ReferenceTypesEnum value : ReferenceTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ReferenceTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ReferenceTypesEnumDeserializer
    extends StdDeserializer<ReferenceTypesEnum> {
        public ReferenceTypesEnumDeserializer() {
            super(ReferenceTypesEnumDeserializer.class);
        }

        public ReferenceTypesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ReferenceTypesEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=UniquenessEnumDeserializer.class)
    public static enum UniquenessEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("none"),
        SERVER("server"),
        GLOBAL("global");

        private String value;

        private UniquenessEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UniquenessEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UniquenessEnum value : UniquenessEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UniquenessEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UniquenessEnumDeserializer
    extends StdDeserializer<UniquenessEnum> {
        public UniquenessEnumDeserializer() {
            super(UniquenessEnumDeserializer.class);
        }

        public UniquenessEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UniquenessEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=ReturnedEnumDeserializer.class)
    public static enum ReturnedEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALWAYS("always"),
        NEVER("never"),
        DEFAULT("default"),
        REQUEST("request");

        private String value;

        private ReturnedEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ReturnedEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ReturnedEnum value : ReturnedEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ReturnedEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ReturnedEnumDeserializer
    extends StdDeserializer<ReturnedEnum> {
        public ReturnedEnumDeserializer() {
            super(ReturnedEnumDeserializer.class);
        }

        public ReturnedEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ReturnedEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MutabilityEnumDeserializer.class)
    public static enum MutabilityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        READWRITE("readWrite"),
        READONLY("readOnly"),
        IMMUTABLE("immutable"),
        WRITEONLY("writeOnly");

        private String value;

        private MutabilityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MutabilityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MutabilityEnum value : MutabilityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MutabilityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MutabilityEnumDeserializer
    extends StdDeserializer<MutabilityEnum> {
        public MutabilityEnumDeserializer() {
            super(MutabilityEnumDeserializer.class);
        }

        public MutabilityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MutabilityEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STRING("string"),
        BOOLEAN("boolean"),
        DECIMAL("decimal"),
        INTEGER("integer"),
        DATETIME("dateTime"),
        REFERENCE("reference"),
        COMPLEX("complex");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

