/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ContentAttachment;
import com.mypurecloud.sdk.v2.model.ContentButtonResponse;
import com.mypurecloud.sdk.v2.model.ContentGeneric;
import com.mypurecloud.sdk.v2.model.ContentList;
import com.mypurecloud.sdk.v2.model.ContentLocation;
import com.mypurecloud.sdk.v2.model.ContentNotificationTemplate;
import com.mypurecloud.sdk.v2.model.ContentPostback;
import com.mypurecloud.sdk.v2.model.ContentQuickReply;
import com.mypurecloud.sdk.v2.model.ContentReaction;
import com.mypurecloud.sdk.v2.model.MessagingRecipient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Message content element.")
public class MessageContent
implements Serializable {
    private ContentTypeEnum contentType = null;
    private ContentLocation location = null;
    private ContentAttachment attachment = null;
    private ContentQuickReply quickReply = null;
    private ContentButtonResponse buttonResponse = null;
    private ContentGeneric generic = null;
    private ContentList list = null;
    private ContentNotificationTemplate template = null;
    private List<ContentReaction> reactions = new ArrayList<ContentReaction>();
    private MessagingRecipient mention = null;
    private ContentPostback postback = null;

    public MessageContent contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of this content element. If contentType = \"Attachment\" only one item is allowed.")
    @JsonProperty(value="contentType")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public MessageContent location(ContentLocation location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(example="null", value="Location content.")
    @JsonProperty(value="location")
    public ContentLocation getLocation() {
        return this.location;
    }

    public void setLocation(ContentLocation location) {
        this.location = location;
    }

    public MessageContent attachment(ContentAttachment attachment) {
        this.attachment = attachment;
        return this;
    }

    @ApiModelProperty(example="null", value="Attachment content.")
    @JsonProperty(value="attachment")
    public ContentAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(ContentAttachment attachment) {
        this.attachment = attachment;
    }

    public MessageContent quickReply(ContentQuickReply quickReply) {
        this.quickReply = quickReply;
        return this;
    }

    @ApiModelProperty(example="null", value="Quick reply content.")
    @JsonProperty(value="quickReply")
    public ContentQuickReply getQuickReply() {
        return this.quickReply;
    }

    public void setQuickReply(ContentQuickReply quickReply) {
        this.quickReply = quickReply;
    }

    public MessageContent buttonResponse(ContentButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
        return this;
    }

    @ApiModelProperty(example="null", value="Button response content.")
    @JsonProperty(value="buttonResponse")
    public ContentButtonResponse getButtonResponse() {
        return this.buttonResponse;
    }

    public void setButtonResponse(ContentButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
    }

    public MessageContent generic(ContentGeneric generic) {
        this.generic = generic;
        return this;
    }

    @ApiModelProperty(example="null", value="Generic content.")
    @JsonProperty(value="generic")
    public ContentGeneric getGeneric() {
        return this.generic;
    }

    public void setGeneric(ContentGeneric generic) {
        this.generic = generic;
    }

    public MessageContent list(ContentList list) {
        this.list = list;
        return this;
    }

    @ApiModelProperty(example="null", value="List content.")
    @JsonProperty(value="list")
    public ContentList getList() {
        return this.list;
    }

    public void setList(ContentList list) {
        this.list = list;
    }

    public MessageContent template(ContentNotificationTemplate template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(example="null", value="Template notification content.")
    @JsonProperty(value="template")
    public ContentNotificationTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(ContentNotificationTemplate template) {
        this.template = template;
    }

    public MessageContent reactions(List<ContentReaction> reactions) {
        this.reactions = reactions;
        return this;
    }

    @ApiModelProperty(example="null", value="A set of reactions to a message.")
    @JsonProperty(value="reactions")
    public List<ContentReaction> getReactions() {
        return this.reactions;
    }

    public void setReactions(List<ContentReaction> reactions) {
        this.reactions = reactions;
    }

    public MessageContent mention(MessagingRecipient mention) {
        this.mention = mention;
        return this;
    }

    @ApiModelProperty(example="null", value="Mention content.")
    @JsonProperty(value="mention")
    public MessagingRecipient getMention() {
        return this.mention;
    }

    public void setMention(MessagingRecipient mention) {
        this.mention = mention;
    }

    public MessageContent postback(ContentPostback postback) {
        this.postback = postback;
        return this;
    }

    @ApiModelProperty(example="null", value="Structured message postback (Deprecated).")
    @JsonProperty(value="postback")
    public ContentPostback getPostback() {
        return this.postback;
    }

    public void setPostback(ContentPostback postback) {
        this.postback = postback;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageContent messageContent = (MessageContent)o;
        return Objects.equals((Object)this.contentType, (Object)messageContent.contentType) && Objects.equals(this.location, messageContent.location) && Objects.equals(this.attachment, messageContent.attachment) && Objects.equals(this.quickReply, messageContent.quickReply) && Objects.equals(this.buttonResponse, messageContent.buttonResponse) && Objects.equals(this.generic, messageContent.generic) && Objects.equals(this.list, messageContent.list) && Objects.equals(this.template, messageContent.template) && Objects.equals(this.reactions, messageContent.reactions) && Objects.equals(this.mention, messageContent.mention) && Objects.equals(this.postback, messageContent.postback);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentType, this.location, this.attachment, this.quickReply, this.buttonResponse, this.generic, this.list, this.template, this.reactions, this.mention, this.postback});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageContent {\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    quickReply: ").append(this.toIndentedString(this.quickReply)).append("\n");
        sb.append("    buttonResponse: ").append(this.toIndentedString(this.buttonResponse)).append("\n");
        sb.append("    generic: ").append(this.toIndentedString(this.generic)).append("\n");
        sb.append("    list: ").append(this.toIndentedString(this.list)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    reactions: ").append(this.toIndentedString(this.reactions)).append("\n");
        sb.append("    mention: ").append(this.toIndentedString(this.mention)).append("\n");
        sb.append("    postback: ").append(this.toIndentedString(this.postback)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ContentTypeEnumDeserializer.class)
    public static enum ContentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ATTACHMENT("Attachment"),
        LOCATION("Location"),
        QUICKREPLY("QuickReply"),
        NOTIFICATION("Notification"),
        GENERICTEMPLATE("GenericTemplate"),
        LISTTEMPLATE("ListTemplate"),
        POSTBACK("Postback"),
        REACTIONS("Reactions"),
        MENTION("Mention"),
        BUTTONRESPONSE("ButtonResponse");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContentTypeEnum value : ContentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ContentTypeEnumDeserializer
    extends StdDeserializer<ContentTypeEnum> {
        public ContentTypeEnumDeserializer() {
            super(ContentTypeEnumDeserializer.class);
        }

        public ContentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ContentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

