/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteWidgetsDeploymentRequest;
import com.mypurecloud.sdk.v2.api.request.GetWidgetsDeploymentRequest;
import com.mypurecloud.sdk.v2.api.request.GetWidgetsDeploymentsRequest;
import com.mypurecloud.sdk.v2.api.request.PostWidgetsDeploymentsRequest;
import com.mypurecloud.sdk.v2.api.request.PutWidgetsDeploymentRequest;
import com.mypurecloud.sdk.v2.model.WidgetDeployment;
import com.mypurecloud.sdk.v2.model.WidgetDeploymentEntityListing;
import java.io.IOException;

public class WidgetsApi {
    private final ApiClient pcapiClient;

    public WidgetsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WidgetsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteWidgetsDeployment(String deploymentId) throws IOException, ApiException {
        this.deleteWidgetsDeployment(this.createDeleteWidgetsDeploymentRequest(deploymentId));
    }

    public ApiResponse<Void> deleteWidgetsDeploymentWithHttpInfo(String deploymentId) throws IOException {
        return this.deleteWidgetsDeployment(this.createDeleteWidgetsDeploymentRequest(deploymentId).withHttpInfo());
    }

    private DeleteWidgetsDeploymentRequest createDeleteWidgetsDeploymentRequest(String deploymentId) {
        return DeleteWidgetsDeploymentRequest.builder().withDeploymentId(deploymentId).build();
    }

    public void deleteWidgetsDeployment(DeleteWidgetsDeploymentRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteWidgetsDeployment(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WidgetDeployment getWidgetsDeployment(String deploymentId) throws IOException, ApiException {
        return this.getWidgetsDeployment(this.createGetWidgetsDeploymentRequest(deploymentId));
    }

    public ApiResponse<WidgetDeployment> getWidgetsDeploymentWithHttpInfo(String deploymentId) throws IOException {
        return this.getWidgetsDeployment(this.createGetWidgetsDeploymentRequest(deploymentId).withHttpInfo());
    }

    private GetWidgetsDeploymentRequest createGetWidgetsDeploymentRequest(String deploymentId) {
        return GetWidgetsDeploymentRequest.builder().withDeploymentId(deploymentId).build();
    }

    public WidgetDeployment getWidgetsDeployment(GetWidgetsDeploymentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WidgetDeployment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WidgetDeployment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WidgetDeployment> getWidgetsDeployment(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WidgetDeployment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WidgetDeploymentEntityListing getWidgetsDeployments() throws IOException, ApiException {
        return this.getWidgetsDeployments(this.createGetWidgetsDeploymentsRequest());
    }

    public ApiResponse<WidgetDeploymentEntityListing> getWidgetsDeploymentsWithHttpInfo() throws IOException {
        return this.getWidgetsDeployments(this.createGetWidgetsDeploymentsRequest().withHttpInfo());
    }

    private GetWidgetsDeploymentsRequest createGetWidgetsDeploymentsRequest() {
        return GetWidgetsDeploymentsRequest.builder().build();
    }

    public WidgetDeploymentEntityListing getWidgetsDeployments(GetWidgetsDeploymentsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WidgetDeploymentEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WidgetDeploymentEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WidgetDeploymentEntityListing> getWidgetsDeployments(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WidgetDeploymentEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WidgetDeployment postWidgetsDeployments(WidgetDeployment body) throws IOException, ApiException {
        return this.postWidgetsDeployments(this.createPostWidgetsDeploymentsRequest(body));
    }

    public ApiResponse<WidgetDeployment> postWidgetsDeploymentsWithHttpInfo(WidgetDeployment body) throws IOException {
        return this.postWidgetsDeployments(this.createPostWidgetsDeploymentsRequest(body).withHttpInfo());
    }

    private PostWidgetsDeploymentsRequest createPostWidgetsDeploymentsRequest(WidgetDeployment body) {
        return PostWidgetsDeploymentsRequest.builder().withBody(body).build();
    }

    public WidgetDeployment postWidgetsDeployments(PostWidgetsDeploymentsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WidgetDeployment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WidgetDeployment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WidgetDeployment> postWidgetsDeployments(ApiRequest<WidgetDeployment> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WidgetDeployment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WidgetDeployment putWidgetsDeployment(String deploymentId, WidgetDeployment body) throws IOException, ApiException {
        return this.putWidgetsDeployment(this.createPutWidgetsDeploymentRequest(deploymentId, body));
    }

    public ApiResponse<WidgetDeployment> putWidgetsDeploymentWithHttpInfo(String deploymentId, WidgetDeployment body) throws IOException {
        return this.putWidgetsDeployment(this.createPutWidgetsDeploymentRequest(deploymentId, body).withHttpInfo());
    }

    private PutWidgetsDeploymentRequest createPutWidgetsDeploymentRequest(String deploymentId, WidgetDeployment body) {
        return PutWidgetsDeploymentRequest.builder().withDeploymentId(deploymentId).withBody(body).build();
    }

    public WidgetDeployment putWidgetsDeployment(PutWidgetsDeploymentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WidgetDeployment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WidgetDeployment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WidgetDeployment> putWidgetsDeployment(ApiRequest<WidgetDeployment> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WidgetDeployment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

