/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ContentAttachment;
import com.mypurecloud.sdk.v2.model.NotificationTemplateParameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Template header object")
public class NotificationTemplateHeader
implements Serializable {
    private TypeEnum type = null;
    private String text = null;
    private ContentAttachment media = null;
    private List<NotificationTemplateParameter> parameters = new ArrayList<NotificationTemplateParameter>();

    public NotificationTemplateHeader type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Template header type")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public NotificationTemplateHeader text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Header text. For WhatsApp, ignored")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public NotificationTemplateHeader media(ContentAttachment media) {
        this.media = media;
        return this;
    }

    @ApiModelProperty(example="null", value="Attachment object")
    @JsonProperty(value="media")
    public ContentAttachment getMedia() {
        return this.media;
    }

    public void setMedia(ContentAttachment media) {
        this.media = media;
    }

    public NotificationTemplateHeader parameters(List<NotificationTemplateParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    @ApiModelProperty(example="null", value="Template parameters for placeholders in template")
    @JsonProperty(value="parameters")
    public List<NotificationTemplateParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<NotificationTemplateParameter> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationTemplateHeader notificationTemplateHeader = (NotificationTemplateHeader)o;
        return Objects.equals((Object)this.type, (Object)notificationTemplateHeader.type) && Objects.equals(this.text, notificationTemplateHeader.text) && Objects.equals(this.media, notificationTemplateHeader.media) && Objects.equals(this.parameters, notificationTemplateHeader.parameters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.text, this.media, this.parameters});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationTemplateHeader {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    media: ").append(this.toIndentedString(this.media)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TEXT("Text"),
        MEDIA("Media");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

