/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="The postback object result of a user clicking in a button")
public class ContentPostback
implements Serializable {
    private String id = null;
    private String text = null;
    private String payload = null;

    public ContentPostback id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="An ID assigned to the postback reply. Each object inside the content array has a unique ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ContentPostback text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="The text inside the button clicked (in the structured message template)")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ContentPostback payload(String payload) {
        this.payload = payload;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Content of the textback payload after clicking a quick reply")
    @JsonProperty(value="payload")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentPostback contentPostback = (ContentPostback)o;
        return Objects.equals(this.id, contentPostback.id) && Objects.equals(this.text, contentPostback.text) && Objects.equals(this.payload, contentPostback.payload);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.text, this.payload);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentPostback {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

