/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.BuAgentScheduleActivity;
import com.mypurecloud.sdk.v2.model.BuScheduleReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class BuAgentScheduleShift
implements Serializable {
    private String id = null;
    private Date startDate = null;
    private Integer lengthMinutes = null;
    private List<BuAgentScheduleActivity> activities = new ArrayList<BuAgentScheduleActivity>();
    private Boolean manuallyEdited = null;
    private BuScheduleReference schedule = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public BuAgentScheduleShift startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The start date of this shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public BuAgentScheduleShift lengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The length of this shift in minutes")
    @JsonProperty(value="lengthMinutes")
    public Integer getLengthMinutes() {
        return this.lengthMinutes;
    }

    public void setLengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
    }

    public BuAgentScheduleShift activities(List<BuAgentScheduleActivity> activities) {
        this.activities = activities;
        return this;
    }

    @ApiModelProperty(example="null", value="The activities associated with this shift")
    @JsonProperty(value="activities")
    public List<BuAgentScheduleActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<BuAgentScheduleActivity> activities) {
        this.activities = activities;
    }

    public BuAgentScheduleShift manuallyEdited(Boolean manuallyEdited) {
        this.manuallyEdited = manuallyEdited;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this shift was manually edited. This is only set by clients and is used for rescheduling")
    @JsonProperty(value="manuallyEdited")
    public Boolean getManuallyEdited() {
        return this.manuallyEdited;
    }

    public void setManuallyEdited(Boolean manuallyEdited) {
        this.manuallyEdited = manuallyEdited;
    }

    public BuAgentScheduleShift schedule(BuScheduleReference schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(example="null", value="The schedule to which this shift belongs")
    @JsonProperty(value="schedule")
    public BuScheduleReference getSchedule() {
        return this.schedule;
    }

    public void setSchedule(BuScheduleReference schedule) {
        this.schedule = schedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuAgentScheduleShift buAgentScheduleShift = (BuAgentScheduleShift)o;
        return Objects.equals(this.id, buAgentScheduleShift.id) && Objects.equals(this.startDate, buAgentScheduleShift.startDate) && Objects.equals(this.lengthMinutes, buAgentScheduleShift.lengthMinutes) && Objects.equals(this.activities, buAgentScheduleShift.activities) && Objects.equals(this.manuallyEdited, buAgentScheduleShift.manuallyEdited) && Objects.equals(this.schedule, buAgentScheduleShift.schedule);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.startDate, this.lengthMinutes, this.activities, this.manuallyEdited, this.schedule);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuAgentScheduleShift {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    lengthMinutes: ").append(this.toIndentedString(this.lengthMinutes)).append("\n");
        sb.append("    activities: ").append(this.toIndentedString(this.activities)).append("\n");
        sb.append("    manuallyEdited: ").append(this.toIndentedString(this.manuallyEdited)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

