/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.SegmentAssignmentSegment;
import com.mypurecloud.sdk.v2.model.SegmentAssignmentSession;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class SegmentAssignment
implements Serializable {
    private String id = null;
    private StateEnum state = null;
    private Date dateAssigned = null;
    private Date dateUnassigned = null;
    private Date dateModified = null;
    private SegmentAssignmentSegment segment = null;
    private String customerId = null;
    private String customerIdType = null;
    private SegmentAssignmentSession session = null;
    private AddressableEntityRef externalContact = null;

    public SegmentAssignment id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the segment assignment.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SegmentAssignment state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="State of the segment assignment.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public SegmentAssignment dateAssigned(Date dateAssigned) {
        this.dateAssigned = dateAssigned;
        return this;
    }

    @ApiModelProperty(example="null", value="Date when the segment was assigned. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateAssigned")
    public Date getDateAssigned() {
        return this.dateAssigned;
    }

    public void setDateAssigned(Date dateAssigned) {
        this.dateAssigned = dateAssigned;
    }

    public SegmentAssignment dateUnassigned(Date dateUnassigned) {
        this.dateUnassigned = dateUnassigned;
        return this;
    }

    @ApiModelProperty(example="null", value="Date when the segment was unassigned. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateUnassigned")
    public Date getDateUnassigned() {
        return this.dateUnassigned;
    }

    public void setDateUnassigned(Date dateUnassigned) {
        this.dateUnassigned = dateUnassigned;
    }

    public SegmentAssignment dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Date when the segment assignment was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public SegmentAssignment segment(SegmentAssignmentSegment segment) {
        this.segment = segment;
        return this;
    }

    @ApiModelProperty(example="null", value="The segment the assignment is for.")
    @JsonProperty(value="segment")
    public SegmentAssignmentSegment getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentAssignmentSegment segment) {
        this.segment = segment;
    }

    public SegmentAssignment customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the customer to which the segment is assigned.")
    @JsonProperty(value="customerId")
    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public SegmentAssignment customerIdType(String customerIdType) {
        this.customerIdType = customerIdType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of customer ID (e.g. cookie, email, phone).")
    @JsonProperty(value="customerIdType")
    public String getCustomerIdType() {
        return this.customerIdType;
    }

    public void setCustomerIdType(String customerIdType) {
        this.customerIdType = customerIdType;
    }

    public SegmentAssignment session(SegmentAssignmentSession session) {
        this.session = session;
        return this;
    }

    @ApiModelProperty(example="null", value="For session-scoped segments, the session for which the segment was assigned.")
    @JsonProperty(value="session")
    public SegmentAssignmentSession getSession() {
        return this.session;
    }

    public void setSession(SegmentAssignmentSession session) {
        this.session = session;
    }

    public SegmentAssignment externalContact(AddressableEntityRef externalContact) {
        this.externalContact = externalContact;
        return this;
    }

    @ApiModelProperty(example="null", value="External contact of the customer to which the segment is assigned.")
    @JsonProperty(value="externalContact")
    public AddressableEntityRef getExternalContact() {
        return this.externalContact;
    }

    public void setExternalContact(AddressableEntityRef externalContact) {
        this.externalContact = externalContact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentAssignment segmentAssignment = (SegmentAssignment)o;
        return Objects.equals(this.id, segmentAssignment.id) && Objects.equals((Object)this.state, (Object)segmentAssignment.state) && Objects.equals(this.dateAssigned, segmentAssignment.dateAssigned) && Objects.equals(this.dateUnassigned, segmentAssignment.dateUnassigned) && Objects.equals(this.dateModified, segmentAssignment.dateModified) && Objects.equals(this.segment, segmentAssignment.segment) && Objects.equals(this.customerId, segmentAssignment.customerId) && Objects.equals(this.customerIdType, segmentAssignment.customerIdType) && Objects.equals(this.session, segmentAssignment.session) && Objects.equals(this.externalContact, segmentAssignment.externalContact);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.dateAssigned, this.dateUnassigned, this.dateModified, this.segment, this.customerId, this.customerIdType, this.session, this.externalContact});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SegmentAssignment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    dateAssigned: ").append(this.toIndentedString(this.dateAssigned)).append("\n");
        sb.append("    dateUnassigned: ").append(this.toIndentedString(this.dateUnassigned)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    segment: ").append(this.toIndentedString(this.segment)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    customerIdType: ").append(this.toIndentedString(this.customerIdType)).append("\n");
        sb.append("    session: ").append(this.toIndentedString(this.session)).append("\n");
        sb.append("    externalContact: ").append(this.toIndentedString(this.externalContact)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASSIGNED("Assigned"),
        UNASSIGNED("Unassigned");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

