/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetJourneyCustomerCustomerIdSegmentsRequest {
    private String customerIdType;
    private String customerId;
    private String pageSize;
    private String after;
    private String segmentScope;
    private String assignmentState;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCustomerIdType() {
        return this.customerIdType;
    }

    public void setCustomerIdType(String customerIdType) {
        this.customerIdType = customerIdType;
    }

    public GetJourneyCustomerCustomerIdSegmentsRequest withCustomerIdType(String customerIdType) {
        this.setCustomerIdType(customerIdType);
        return this;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public GetJourneyCustomerCustomerIdSegmentsRequest withCustomerId(String customerId) {
        this.setCustomerId(customerId);
        return this;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public GetJourneyCustomerCustomerIdSegmentsRequest withPageSize(String pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public String getAfter() {
        return this.after;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public GetJourneyCustomerCustomerIdSegmentsRequest withAfter(String after) {
        this.setAfter(after);
        return this;
    }

    public String getSegmentScope() {
        return this.segmentScope;
    }

    public void setSegmentScope(String segmentScope) {
        this.segmentScope = segmentScope;
    }

    public GetJourneyCustomerCustomerIdSegmentsRequest withSegmentScope(String segmentScope) {
        this.setSegmentScope(segmentScope);
        return this;
    }

    public String getAssignmentState() {
        return this.assignmentState;
    }

    public void setAssignmentState(String assignmentState) {
        this.assignmentState = assignmentState;
    }

    public GetJourneyCustomerCustomerIdSegmentsRequest withAssignmentState(String assignmentState) {
        this.setAssignmentState(assignmentState);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetJourneyCustomerCustomerIdSegmentsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.customerIdType == null) {
            throw new IllegalStateException("Missing the required parameter 'customerIdType' when building request for GetJourneyCustomerCustomerIdSegmentsRequest.");
        }
        if (this.customerId == null) {
            throw new IllegalStateException("Missing the required parameter 'customerId' when building request for GetJourneyCustomerCustomerIdSegmentsRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/journey/customers/{customerIdType}/{customerId}/segments").withPathParameter("customerIdType", this.customerIdType).withPathParameter("customerId", this.customerId).withQueryParameters("pageSize", "", this.pageSize).withQueryParameters("after", "", this.after).withQueryParameters("segmentScope", "", this.segmentScope).withQueryParameters("assignmentState", "", this.assignmentState).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String customerIdType, String customerId) {
        return new Builder().withRequiredParams(customerIdType, customerId);
    }

    public static class Builder {
        private final GetJourneyCustomerCustomerIdSegmentsRequest request = new GetJourneyCustomerCustomerIdSegmentsRequest();

        private Builder() {
        }

        public Builder withCustomerIdType(String customerIdType) {
            this.request.setCustomerIdType(customerIdType);
            return this;
        }

        public Builder withCustomerId(String customerId) {
            this.request.setCustomerId(customerId);
            return this;
        }

        public Builder withPageSize(String pageSize) {
            this.request.setPageSize(pageSize);
            return this;
        }

        public Builder withAfter(String after) {
            this.request.setAfter(after);
            return this;
        }

        public Builder withSegmentScope(String segmentScope) {
            this.request.setSegmentScope(segmentScope);
            return this;
        }

        public Builder withSegmentScope(segmentScopeValues segmentScope) {
            this.request.setSegmentScope(segmentScope.toString());
            return this;
        }

        public Builder withAssignmentState(String assignmentState) {
            this.request.setAssignmentState(assignmentState);
            return this;
        }

        public Builder withAssignmentState(assignmentStateValues assignmentState) {
            this.request.setAssignmentState(assignmentState.toString());
            return this;
        }

        public Builder withRequiredParams(String customerIdType, String customerId) {
            this.request.setCustomerIdType(customerIdType);
            this.request.setCustomerId(customerId);
            return this;
        }

        public GetJourneyCustomerCustomerIdSegmentsRequest build() {
            if (this.request.customerIdType == null) {
                throw new IllegalStateException("Missing the required parameter 'customerIdType' when building request for GetJourneyCustomerCustomerIdSegmentsRequest.");
            }
            if (this.request.customerId == null) {
                throw new IllegalStateException("Missing the required parameter 'customerId' when building request for GetJourneyCustomerCustomerIdSegmentsRequest.");
            }
            return this.request;
        }
    }

    public static enum assignmentStateValues {
        ASSIGNED("Assigned"),
        UNASSIGNED("Unassigned");

        private String value;

        private assignmentStateValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static assignmentStateValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (assignmentStateValues value : assignmentStateValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return assignmentStateValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum segmentScopeValues {
        SESSION("Session"),
        CUSTOMER("Customer");

        private String value;

        private segmentScopeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static segmentScopeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (segmentScopeValues value : segmentScopeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return segmentScopeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

