/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Development Activity object")
public class DevelopmentActivity
implements Serializable {
    private String id = null;
    private Date dateCompleted = null;
    private UserReference createdBy = null;
    private Date dateCreated = null;
    private String selfUri = null;
    private String name = null;
    private TypeEnum type = null;
    private StatusEnum status = null;
    private Date dateDue = null;
    private UserReference facilitator = null;
    private List<UserReference> attendees = new ArrayList<UserReference>();
    private Boolean isOverdue = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="Date that activity was completed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCompleted")
    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    public DevelopmentActivity createdBy(UserReference createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User that created activity")
    @JsonProperty(value="createdBy")
    public UserReference getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserReference createdBy) {
        this.createdBy = createdBy;
    }

    @ApiModelProperty(example="null", value="Date activity was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public DevelopmentActivity name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the activity")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DevelopmentActivity type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of activity")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public DevelopmentActivity status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the activity")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public DevelopmentActivity dateDue(Date dateDue) {
        this.dateDue = dateDue;
        return this;
    }

    @ApiModelProperty(example="null", value="Due date for completion of the activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateDue")
    public Date getDateDue() {
        return this.dateDue;
    }

    public void setDateDue(Date dateDue) {
        this.dateDue = dateDue;
    }

    public DevelopmentActivity facilitator(UserReference facilitator) {
        this.facilitator = facilitator;
        return this;
    }

    @ApiModelProperty(example="null", value="Facilitator of the activity")
    @JsonProperty(value="facilitator")
    public UserReference getFacilitator() {
        return this.facilitator;
    }

    public void setFacilitator(UserReference facilitator) {
        this.facilitator = facilitator;
    }

    public DevelopmentActivity attendees(List<UserReference> attendees) {
        this.attendees = attendees;
        return this;
    }

    @ApiModelProperty(example="null", value="List of users attending the activity")
    @JsonProperty(value="attendees")
    public List<UserReference> getAttendees() {
        return this.attendees;
    }

    public void setAttendees(List<UserReference> attendees) {
        this.attendees = attendees;
    }

    public DevelopmentActivity isOverdue(Boolean isOverdue) {
        this.isOverdue = isOverdue;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if the activity is overdue")
    @JsonProperty(value="isOverdue")
    public Boolean getIsOverdue() {
        return this.isOverdue;
    }

    public void setIsOverdue(Boolean isOverdue) {
        this.isOverdue = isOverdue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DevelopmentActivity developmentActivity = (DevelopmentActivity)o;
        return Objects.equals(this.id, developmentActivity.id) && Objects.equals(this.dateCompleted, developmentActivity.dateCompleted) && Objects.equals(this.createdBy, developmentActivity.createdBy) && Objects.equals(this.dateCreated, developmentActivity.dateCreated) && Objects.equals(this.selfUri, developmentActivity.selfUri) && Objects.equals(this.name, developmentActivity.name) && Objects.equals((Object)this.type, (Object)developmentActivity.type) && Objects.equals((Object)this.status, (Object)developmentActivity.status) && Objects.equals(this.dateDue, developmentActivity.dateDue) && Objects.equals(this.facilitator, developmentActivity.facilitator) && Objects.equals(this.attendees, developmentActivity.attendees) && Objects.equals(this.isOverdue, developmentActivity.isOverdue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.dateCompleted, this.createdBy, this.dateCreated, this.selfUri, this.name, this.type, this.status, this.dateDue, this.facilitator, this.attendees, this.isOverdue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DevelopmentActivity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    dateCompleted: ").append(this.toIndentedString(this.dateCompleted)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    dateDue: ").append(this.toIndentedString(this.dateDue)).append("\n");
        sb.append("    facilitator: ").append(this.toIndentedString(this.facilitator)).append("\n");
        sb.append("    attendees: ").append(this.toIndentedString(this.attendees)).append("\n");
        sb.append("    isOverdue: ").append(this.toIndentedString(this.isOverdue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PLANNED("Planned"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed"),
        INVALIDSCHEDULE("InvalidSchedule");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INFORMATIONAL("Informational"),
        ASSESSEDCONTENT("AssessedContent"),
        QUESTIONNAIRE("Questionnaire"),
        COACHING("Coaching");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

