/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.PostTextMessage;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PostTextResponse
implements Serializable {
    private BotStateEnum botState = null;
    private List<PostTextMessage> replyMessages = new ArrayList<PostTextMessage>();
    private String intentName = null;
    private Map<String, String> slots = null;
    private String botCorrelationId = null;
    private Map<String, Object> amazonLex = null;
    private Map<String, Object> googleDialogFlow = null;
    private Map<String, Object> genesysDialogEngine = null;

    public PostTextResponse botState(BotStateEnum botState) {
        this.botState = botState;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The state of the bot after completion of the request")
    @JsonProperty(value="botState")
    public BotStateEnum getBotState() {
        return this.botState;
    }

    public void setBotState(BotStateEnum botState) {
        this.botState = botState;
    }

    public PostTextResponse replyMessages(List<PostTextMessage> replyMessages) {
        this.replyMessages = replyMessages;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of messages to respond with, if any")
    @JsonProperty(value="replyMessages")
    public List<PostTextMessage> getReplyMessages() {
        return this.replyMessages;
    }

    public void setReplyMessages(List<PostTextMessage> replyMessages) {
        this.replyMessages = replyMessages;
    }

    public PostTextResponse intentName(String intentName) {
        this.intentName = intentName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the intent the bot is either processing or has processed, this will be blank if no intent could be detected.")
    @JsonProperty(value="intentName")
    public String getIntentName() {
        return this.intentName;
    }

    public void setIntentName(String intentName) {
        this.intentName = intentName;
    }

    public PostTextResponse slots(Map<String, String> slots) {
        this.slots = slots;
        return this;
    }

    @ApiModelProperty(example="null", value="Data parameters detected and filled by the bot.")
    @JsonProperty(value="slots")
    public Map<String, String> getSlots() {
        return this.slots;
    }

    public void setSlots(Map<String, String> slots) {
        this.slots = slots;
    }

    public PostTextResponse botCorrelationId(String botCorrelationId) {
        this.botCorrelationId = botCorrelationId;
        return this;
    }

    @ApiModelProperty(example="null", value="The optional ID specified in the request")
    @JsonProperty(value="botCorrelationId")
    public String getBotCorrelationId() {
        return this.botCorrelationId;
    }

    public void setBotCorrelationId(String botCorrelationId) {
        this.botCorrelationId = botCorrelationId;
    }

    public PostTextResponse amazonLex(Map<String, Object> amazonLex) {
        this.amazonLex = amazonLex;
        return this;
    }

    @ApiModelProperty(example="null", value="Raw data response from AWS (if called)")
    @JsonProperty(value="amazonLex")
    public Map<String, Object> getAmazonLex() {
        return this.amazonLex;
    }

    public void setAmazonLex(Map<String, Object> amazonLex) {
        this.amazonLex = amazonLex;
    }

    public PostTextResponse googleDialogFlow(Map<String, Object> googleDialogFlow) {
        this.googleDialogFlow = googleDialogFlow;
        return this;
    }

    @ApiModelProperty(example="null", value="Raw data response from Google Dialogflow (if called)")
    @JsonProperty(value="googleDialogFlow")
    public Map<String, Object> getGoogleDialogFlow() {
        return this.googleDialogFlow;
    }

    public void setGoogleDialogFlow(Map<String, Object> googleDialogFlow) {
        this.googleDialogFlow = googleDialogFlow;
    }

    public PostTextResponse genesysDialogEngine(Map<String, Object> genesysDialogEngine) {
        this.genesysDialogEngine = genesysDialogEngine;
        return this;
    }

    @ApiModelProperty(example="null", value="Raw data response from Genesys' Dialogengine (if called)")
    @JsonProperty(value="genesysDialogEngine")
    public Map<String, Object> getGenesysDialogEngine() {
        return this.genesysDialogEngine;
    }

    public void setGenesysDialogEngine(Map<String, Object> genesysDialogEngine) {
        this.genesysDialogEngine = genesysDialogEngine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostTextResponse postTextResponse = (PostTextResponse)o;
        return Objects.equals((Object)this.botState, (Object)postTextResponse.botState) && Objects.equals(this.replyMessages, postTextResponse.replyMessages) && Objects.equals(this.intentName, postTextResponse.intentName) && Objects.equals(this.slots, postTextResponse.slots) && Objects.equals(this.botCorrelationId, postTextResponse.botCorrelationId) && Objects.equals(this.amazonLex, postTextResponse.amazonLex) && Objects.equals(this.googleDialogFlow, postTextResponse.googleDialogFlow) && Objects.equals(this.genesysDialogEngine, postTextResponse.genesysDialogEngine);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.botState, this.replyMessages, this.intentName, this.slots, this.botCorrelationId, this.amazonLex, this.googleDialogFlow, this.genesysDialogEngine});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostTextResponse {\n");
        sb.append("    botState: ").append(this.toIndentedString((Object)this.botState)).append("\n");
        sb.append("    replyMessages: ").append(this.toIndentedString(this.replyMessages)).append("\n");
        sb.append("    intentName: ").append(this.toIndentedString(this.intentName)).append("\n");
        sb.append("    slots: ").append(this.toIndentedString(this.slots)).append("\n");
        sb.append("    botCorrelationId: ").append(this.toIndentedString(this.botCorrelationId)).append("\n");
        sb.append("    amazonLex: ").append(this.toIndentedString(this.amazonLex)).append("\n");
        sb.append("    googleDialogFlow: ").append(this.toIndentedString(this.googleDialogFlow)).append("\n");
        sb.append("    genesysDialogEngine: ").append(this.toIndentedString(this.genesysDialogEngine)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum BotStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COMPLETE("Complete"),
        FAILED("Failed"),
        MOREDATA("MoreData");

        private String value;

        private BotStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static BotStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (BotStateEnum value : BotStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return BotStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

