/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.QueryRequestFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CoachingAppointmentAggregateRequest
implements Serializable {
    private String interval = null;
    private List<MetricsEnum> metrics = new ArrayList<MetricsEnum>();
    private List<GroupByEnum> groupBy = new ArrayList<GroupByEnum>();
    private QueryRequestFilter filter = null;

    public CoachingAppointmentAggregateRequest interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Interval to aggregate across. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public CoachingAppointmentAggregateRequest metrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of metrics to aggregate.  If omitted, all metrics are returned.")
    @JsonProperty(value="metrics")
    public List<MetricsEnum> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
    }

    public CoachingAppointmentAggregateRequest groupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @ApiModelProperty(example="null", value="An optional list of items by which to group the result data.")
    @JsonProperty(value="groupBy")
    public List<GroupByEnum> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
    }

    public CoachingAppointmentAggregateRequest filter(QueryRequestFilter filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The filter applied to the data")
    @JsonProperty(value="filter")
    public QueryRequestFilter getFilter() {
        return this.filter;
    }

    public void setFilter(QueryRequestFilter filter) {
        this.filter = filter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoachingAppointmentAggregateRequest coachingAppointmentAggregateRequest = (CoachingAppointmentAggregateRequest)o;
        return Objects.equals(this.interval, coachingAppointmentAggregateRequest.interval) && Objects.equals(this.metrics, coachingAppointmentAggregateRequest.metrics) && Objects.equals(this.groupBy, coachingAppointmentAggregateRequest.groupBy) && Objects.equals(this.filter, coachingAppointmentAggregateRequest.filter);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.metrics, this.groupBy, this.filter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CoachingAppointmentAggregateRequest {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GroupByEnum {
        ATTENDEEID("attendeeId");

        private String value;

        private GroupByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GroupByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GroupByEnum value : GroupByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GroupByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum MetricsEnum {
        NACTIVITIES("nActivities"),
        NPLANNEDACTIVITIES("nPlannedActivities"),
        NINPROGRESSACTIVITIES("nInProgressActivities"),
        NCOMPLETEACTIVITIES("nCompleteActivities"),
        NOVERDUEACTIVITIES("nOverdueActivities"),
        NINVALIDSCHEDULEACTIVITIES("nInvalidScheduleActivities");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricsEnum value : MetricsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

