/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.JsonSchemaDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Input requirements of Action.")
public class ActionInput
implements Serializable {
    private JsonSchemaDocument inputSchema = null;
    private JsonSchemaDocument inputSchemaFlattened = null;
    private String inputSchemaUri = null;

    public ActionInput inputSchema(JsonSchemaDocument inputSchema) {
        this.inputSchema = inputSchema;
        return this;
    }

    @ApiModelProperty(example="null", value="JSON Schema that defines the body of the request that the client (edge/architect/postman) is sending to the service, on the /execute path. If the 'flatten' query parameter is omitted or false, this field will be returned. Either inputSchema or inputSchemaFlattened will be returned, not both.")
    @JsonProperty(value="inputSchema")
    public JsonSchemaDocument getInputSchema() {
        return this.inputSchema;
    }

    public void setInputSchema(JsonSchemaDocument inputSchema) {
        this.inputSchema = inputSchema;
    }

    public ActionInput inputSchemaFlattened(JsonSchemaDocument inputSchemaFlattened) {
        this.inputSchemaFlattened = inputSchemaFlattened;
        return this;
    }

    @ApiModelProperty(example="null", value="JSON Schema that defines the body of the request that the client (edge/architect/postman) is sending to the service, on the /execute path. The schema is transformed based on Architect's flattened format. If the 'flatten' query parameter is supplied as true, this field will be returned. Either inputSchema or inputSchemaFlattened will be returned, not both.")
    @JsonProperty(value="inputSchemaFlattened")
    public JsonSchemaDocument getInputSchemaFlattened() {
        return this.inputSchemaFlattened;
    }

    public void setInputSchemaFlattened(JsonSchemaDocument inputSchemaFlattened) {
        this.inputSchemaFlattened = inputSchemaFlattened;
    }

    public ActionInput inputSchemaUri(String inputSchemaUri) {
        this.inputSchemaUri = inputSchemaUri;
        return this;
    }

    @ApiModelProperty(example="null", value="The URI of the input schema")
    @JsonProperty(value="inputSchemaUri")
    public String getInputSchemaUri() {
        return this.inputSchemaUri;
    }

    public void setInputSchemaUri(String inputSchemaUri) {
        this.inputSchemaUri = inputSchemaUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionInput actionInput = (ActionInput)o;
        return Objects.equals(this.inputSchema, actionInput.inputSchema) && Objects.equals(this.inputSchemaFlattened, actionInput.inputSchemaFlattened) && Objects.equals(this.inputSchemaUri, actionInput.inputSchemaUri);
    }

    public int hashCode() {
        return Objects.hash(this.inputSchema, this.inputSchemaFlattened, this.inputSchemaUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionInput {\n");
        sb.append("    inputSchema: ").append(this.toIndentedString(this.inputSchema)).append("\n");
        sb.append("    inputSchemaFlattened: ").append(this.toIndentedString(this.inputSchemaFlattened)).append("\n");
        sb.append("    inputSchemaUri: ").append(this.toIndentedString(this.inputSchemaUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

