/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetUsageQueryExecutionIdResultsRequest;
import com.mypurecloud.sdk.v2.api.request.PostUsageQueryRequest;
import com.mypurecloud.sdk.v2.model.ApiUsageQuery;
import com.mypurecloud.sdk.v2.model.ApiUsageQueryResult;
import com.mypurecloud.sdk.v2.model.UsageExecutionResult;
import java.io.IOException;

public class UsageApi {
    private final ApiClient pcapiClient;

    public UsageApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsageApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public ApiUsageQueryResult getUsageQueryExecutionIdResults(String executionId) throws IOException, ApiException {
        return this.getUsageQueryExecutionIdResults(this.createGetUsageQueryExecutionIdResultsRequest(executionId));
    }

    public ApiResponse<ApiUsageQueryResult> getUsageQueryExecutionIdResultsWithHttpInfo(String executionId) throws IOException {
        return this.getUsageQueryExecutionIdResults(this.createGetUsageQueryExecutionIdResultsRequest(executionId).withHttpInfo());
    }

    private GetUsageQueryExecutionIdResultsRequest createGetUsageQueryExecutionIdResultsRequest(String executionId) {
        return GetUsageQueryExecutionIdResultsRequest.builder().withExecutionId(executionId).build();
    }

    public ApiUsageQueryResult getUsageQueryExecutionIdResults(GetUsageQueryExecutionIdResultsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ApiUsageQueryResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ApiUsageQueryResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ApiUsageQueryResult> getUsageQueryExecutionIdResults(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ApiUsageQueryResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsageExecutionResult postUsageQuery(ApiUsageQuery body) throws IOException, ApiException {
        return this.postUsageQuery(this.createPostUsageQueryRequest(body));
    }

    public ApiResponse<UsageExecutionResult> postUsageQueryWithHttpInfo(ApiUsageQuery body) throws IOException {
        return this.postUsageQuery(this.createPostUsageQueryRequest(body).withHttpInfo());
    }

    private PostUsageQueryRequest createPostUsageQueryRequest(ApiUsageQuery body) {
        return PostUsageQueryRequest.builder().withBody(body).build();
    }

    public UsageExecutionResult postUsageQuery(PostUsageQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsageExecutionResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsageExecutionResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsageExecutionResult> postUsageQuery(ApiRequest<ApiUsageQuery> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsageExecutionResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

