/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetConversationsCallParticipantWrapupRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String callId;
    private String participantId;
    private Boolean provisional;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public GetConversationsCallParticipantWrapupRequest withCallId(String callId) {
        this.setCallId(callId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public GetConversationsCallParticipantWrapupRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public Boolean getProvisional() {
        return this.provisional;
    }

    public void setProvisional(Boolean provisional) {
        this.provisional = provisional;
    }

    public GetConversationsCallParticipantWrapupRequest withProvisional(Boolean provisional) {
        this.setProvisional(provisional);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetConversationsCallParticipantWrapupRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() throws ApiException {
        if (this.callId == null) {
            throw new ApiException(400, "Missing the required parameter 'callId' when building request for GetConversationsCallParticipantWrapupRequest.");
        }
        if (this.participantId == null) {
            throw new ApiException(400, "Missing the required parameter 'participantId' when building request for GetConversationsCallParticipantWrapupRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/conversations/calls/{callId}/participants/{participantId}/wrapup").withPathParameter("callId", this.callId).withPathParameter("participantId", this.participantId).withQueryParameters("provisional", "", this.provisional).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String callId, String participantId) {
        return new Builder().withRequiredParams(callId, participantId);
    }

    public static class Builder {
        private final GetConversationsCallParticipantWrapupRequest request = new GetConversationsCallParticipantWrapupRequest();

        private Builder() {
        }

        public Builder withCallId(String callId) {
            this.request.setCallId(callId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withProvisional(Boolean provisional) {
            this.request.setProvisional(provisional);
            return this;
        }

        public Builder withRequiredParams(String callId, String participantId) {
            this.request.setCallId(callId);
            this.request.setParticipantId(participantId);
            return this;
        }

        public GetConversationsCallParticipantWrapupRequest build() {
            return this.request;
        }
    }
}

