/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.MediaParticipantRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PatchConversationsChatParticipantCommunicationRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String chatId;
    private String participantId;
    private String communicationId;
    private MediaParticipantRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public PatchConversationsChatParticipantCommunicationRequest withChatId(String chatId) {
        this.setChatId(chatId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public PatchConversationsChatParticipantCommunicationRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public String getCommunicationId() {
        return this.communicationId;
    }

    public void setCommunicationId(String communicationId) {
        this.communicationId = communicationId;
    }

    public PatchConversationsChatParticipantCommunicationRequest withCommunicationId(String communicationId) {
        this.setCommunicationId(communicationId);
        return this;
    }

    public MediaParticipantRequest getBody() {
        return this.body;
    }

    public void setBody(MediaParticipantRequest body) {
        this.body = body;
    }

    public PatchConversationsChatParticipantCommunicationRequest withBody(MediaParticipantRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchConversationsChatParticipantCommunicationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<MediaParticipantRequest> withHttpInfo() throws ApiException {
        if (this.chatId == null) {
            throw new ApiException(400, "Missing the required parameter 'chatId' when building request for PatchConversationsChatParticipantCommunicationRequest.");
        }
        if (this.participantId == null) {
            throw new ApiException(400, "Missing the required parameter 'participantId' when building request for PatchConversationsChatParticipantCommunicationRequest.");
        }
        if (this.communicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'communicationId' when building request for PatchConversationsChatParticipantCommunicationRequest.");
        }
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PatchConversationsChatParticipantCommunicationRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/conversations/chats/{chatId}/participants/{participantId}/communications/{communicationId}").withPathParameter("chatId", this.chatId).withPathParameter("participantId", this.participantId).withPathParameter("communicationId", this.communicationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String chatId, String participantId, String communicationId, MediaParticipantRequest body) {
        return new Builder().withRequiredParams(chatId, participantId, communicationId, body);
    }

    public static class Builder {
        private final PatchConversationsChatParticipantCommunicationRequest request = new PatchConversationsChatParticipantCommunicationRequest();

        private Builder() {
        }

        public Builder withChatId(String chatId) {
            this.request.setChatId(chatId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withCommunicationId(String communicationId) {
            this.request.setCommunicationId(communicationId);
            return this;
        }

        public Builder withBody(MediaParticipantRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String chatId, String participantId, String communicationId, MediaParticipantRequest body) {
            this.request.setChatId(chatId);
            this.request.setParticipantId(participantId);
            this.request.setCommunicationId(communicationId);
            this.request.setBody(body);
            return this;
        }

        public PatchConversationsChatParticipantCommunicationRequest build() {
            return this.request;
        }
    }
}

