/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.DeleteQualityCalibrationRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteQualityConversationEvaluationRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteQualityFormRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteQualityKeywordsetRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteQualityKeywordsetsRequest;
import com.mypurecloud.sdk.v2.api.request.GetQualityAgentsActivityRequest;
import com.mypurecloud.sdk.v2.api.request.GetQualityCalibrationRequest;
import com.mypurecloud.sdk.v2.api.request.GetQualityCalibrationsRequest;
import com.mypurecloud.sdk.v2.api.request.GetQualityConversationAuditsRequest;
import com.mypurecloud.sdk.v2.api.request.GetQualityConversationEvaluationRequest;
import com.mypurecloud.sdk.v2.api.request.GetQualityEvaluationsQueryRequest;
import com.mypurecloud.sdk.v2.api.request.GetQualityEvaluatorsActivityRequest;
import com.mypurecloud.sdk.v2.api.request.GetQualityFormRequest;
import com.mypurecloud.sdk.v2.api.request.GetQualityFormVersionsRequest;
import com.mypurecloud.sdk.v2.api.request.GetQualityFormsRequest;
import com.mypurecloud.sdk.v2.api.request.GetQualityKeywordsetRequest;
import com.mypurecloud.sdk.v2.api.request.GetQualityKeywordsetsRequest;
import com.mypurecloud.sdk.v2.api.request.GetQualityPublishedformRequest;
import com.mypurecloud.sdk.v2.api.request.GetQualityPublishedformsRequest;
import com.mypurecloud.sdk.v2.api.request.PostAnalyticsEvaluationsAggregatesQueryRequest;
import com.mypurecloud.sdk.v2.api.request.PostQualityCalibrationsRequest;
import com.mypurecloud.sdk.v2.api.request.PostQualityConversationEvaluationsRequest;
import com.mypurecloud.sdk.v2.api.request.PostQualityEvaluationsScoringRequest;
import com.mypurecloud.sdk.v2.api.request.PostQualityFormsRequest;
import com.mypurecloud.sdk.v2.api.request.PostQualityKeywordsetsRequest;
import com.mypurecloud.sdk.v2.api.request.PostQualityPublishedformsRequest;
import com.mypurecloud.sdk.v2.api.request.PostQualitySpotabilityRequest;
import com.mypurecloud.sdk.v2.api.request.PutQualityCalibrationRequest;
import com.mypurecloud.sdk.v2.api.request.PutQualityConversationEvaluationRequest;
import com.mypurecloud.sdk.v2.api.request.PutQualityFormRequest;
import com.mypurecloud.sdk.v2.api.request.PutQualityKeywordsetRequest;
import com.mypurecloud.sdk.v2.model.AgentActivityEntityListing;
import com.mypurecloud.sdk.v2.model.AggregateQueryResponse;
import com.mypurecloud.sdk.v2.model.AggregationQuery;
import com.mypurecloud.sdk.v2.model.Calibration;
import com.mypurecloud.sdk.v2.model.CalibrationCreate;
import com.mypurecloud.sdk.v2.model.CalibrationEntityListing;
import com.mypurecloud.sdk.v2.model.Evaluation;
import com.mypurecloud.sdk.v2.model.EvaluationEntityListing;
import com.mypurecloud.sdk.v2.model.EvaluationForm;
import com.mypurecloud.sdk.v2.model.EvaluationFormAndScoringSet;
import com.mypurecloud.sdk.v2.model.EvaluationFormEntityListing;
import com.mypurecloud.sdk.v2.model.EvaluationScoringSet;
import com.mypurecloud.sdk.v2.model.EvaluatorActivityEntityListing;
import com.mypurecloud.sdk.v2.model.KeywordSet;
import com.mypurecloud.sdk.v2.model.KeywordSetEntityListing;
import com.mypurecloud.sdk.v2.model.QualityAuditPage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class QualityApi {
    private final ApiClient pcapiClient;

    public QualityApi() {
        this(Configuration.getDefaultApiClient());
    }

    public QualityApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Calibration deleteQualityCalibration(String calibrationId, String calibratorId) throws ApiException {
        return this.deleteQualityCalibrationWithHttpInfo(calibrationId, calibratorId).getBody();
    }

    public ApiResponse<Calibration> deleteQualityCalibrationWithHttpInfo(String calibrationId, String calibratorId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (calibrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'calibrationId' when calling deleteQualityCalibration");
        }
        if (calibratorId == null) {
            throw new ApiException(400, "Missing the required parameter 'calibratorId' when calling deleteQualityCalibration");
        }
        String pclocalVarPath = "/api/v2/quality/calibrations/{calibrationId}".replaceAll("\\{format\\}", "json").replaceAll("\\{calibrationId\\}", this.pcapiClient.escapeString(calibrationId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "calibratorId", calibratorId));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Calibration>(){});
    }

    public Calibration deleteQualityCalibration(DeleteQualityCalibrationRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Calibration>(){});
    }

    public ApiResponse<Calibration> deleteQualityCalibration(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Calibration>(){});
    }

    public Evaluation deleteQualityConversationEvaluation(String conversationId, String evaluationId, String expand) throws ApiException {
        return this.deleteQualityConversationEvaluationWithHttpInfo(conversationId, evaluationId, expand).getBody();
    }

    public ApiResponse<Evaluation> deleteQualityConversationEvaluationWithHttpInfo(String conversationId, String evaluationId, String expand) throws ApiException {
        Object pclocalVarPostBody = null;
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling deleteQualityConversationEvaluation");
        }
        if (evaluationId == null) {
            throw new ApiException(400, "Missing the required parameter 'evaluationId' when calling deleteQualityConversationEvaluation");
        }
        String pclocalVarPath = "/api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId}".replaceAll("\\{format\\}", "json").replaceAll("\\{conversationId\\}", this.pcapiClient.escapeString(conversationId.toString())).replaceAll("\\{evaluationId\\}", this.pcapiClient.escapeString(evaluationId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "expand", expand));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Evaluation>(){});
    }

    public Evaluation deleteQualityConversationEvaluation(DeleteQualityConversationEvaluationRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Evaluation>(){});
    }

    public ApiResponse<Evaluation> deleteQualityConversationEvaluation(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Evaluation>(){});
    }

    public String deleteQualityForm(String formId) throws ApiException {
        return this.deleteQualityFormWithHttpInfo(formId).getBody();
    }

    public ApiResponse<String> deleteQualityFormWithHttpInfo(String formId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (formId == null) {
            throw new ApiException(400, "Missing the required parameter 'formId' when calling deleteQualityForm");
        }
        String pclocalVarPath = "/api/v2/quality/forms/{formId}".replaceAll("\\{format\\}", "json").replaceAll("\\{formId\\}", this.pcapiClient.escapeString(formId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<String>(){});
    }

    public String deleteQualityForm(DeleteQualityFormRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<String>(){});
    }

    public ApiResponse<String> deleteQualityForm(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<String>(){});
    }

    public void deleteQualityKeywordset(String keywordSetId) throws ApiException {
        this.deleteQualityKeywordsetWithHttpInfo(keywordSetId);
    }

    public ApiResponse<Void> deleteQualityKeywordsetWithHttpInfo(String keywordSetId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (keywordSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'keywordSetId' when calling deleteQualityKeywordset");
        }
        String pclocalVarPath = "/api/v2/quality/keywordsets/{keywordSetId}".replaceAll("\\{format\\}", "json").replaceAll("\\{keywordSetId\\}", this.pcapiClient.escapeString(keywordSetId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, null);
    }

    public void deleteQualityKeywordset(DeleteQualityKeywordsetRequest request) throws ApiException {
        this.pcapiClient.invokeAPI(request.withHttpInfo(), null);
    }

    public ApiResponse<Void> deleteQualityKeywordset(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, null);
    }

    public String deleteQualityKeywordsets(String ids) throws ApiException {
        return this.deleteQualityKeywordsetsWithHttpInfo(ids).getBody();
    }

    public ApiResponse<String> deleteQualityKeywordsetsWithHttpInfo(String ids) throws ApiException {
        Object pclocalVarPostBody = null;
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling deleteQualityKeywordsets");
        }
        String pclocalVarPath = "/api/v2/quality/keywordsets".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "ids", ids));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<String>(){});
    }

    public String deleteQualityKeywordsets(DeleteQualityKeywordsetsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<String>(){});
    }

    public ApiResponse<String> deleteQualityKeywordsets(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<String>(){});
    }

    public AgentActivityEntityListing getQualityAgentsActivity(Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, Date startTime, Date endTime, List<Object> agentUserId, String evaluatorUserId, String name, String group) throws ApiException {
        return this.getQualityAgentsActivityWithHttpInfo(pageSize, pageNumber, sortBy, expand, nextPage, previousPage, startTime, endTime, agentUserId, evaluatorUserId, name, group).getBody();
    }

    public ApiResponse<AgentActivityEntityListing> getQualityAgentsActivityWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, Date startTime, Date endTime, List<Object> agentUserId, String evaluatorUserId, String name, String group) throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/quality/agents/activity".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortBy", sortBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "expand", expand));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "nextPage", nextPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "previousPage", previousPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "startTime", startTime));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "endTime", endTime));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "agentUserId", agentUserId));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "evaluatorUserId", evaluatorUserId));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "name", name));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "group", group));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<AgentActivityEntityListing>(){});
    }

    public AgentActivityEntityListing getQualityAgentsActivity(GetQualityAgentsActivityRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<AgentActivityEntityListing>(){});
    }

    public ApiResponse<AgentActivityEntityListing> getQualityAgentsActivity(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<AgentActivityEntityListing>(){});
    }

    public Calibration getQualityCalibration(String calibrationId, String calibratorId) throws ApiException {
        return this.getQualityCalibrationWithHttpInfo(calibrationId, calibratorId).getBody();
    }

    public ApiResponse<Calibration> getQualityCalibrationWithHttpInfo(String calibrationId, String calibratorId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (calibrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'calibrationId' when calling getQualityCalibration");
        }
        if (calibratorId == null) {
            throw new ApiException(400, "Missing the required parameter 'calibratorId' when calling getQualityCalibration");
        }
        String pclocalVarPath = "/api/v2/quality/calibrations/{calibrationId}".replaceAll("\\{format\\}", "json").replaceAll("\\{calibrationId\\}", this.pcapiClient.escapeString(calibrationId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "calibratorId", calibratorId));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Calibration>(){});
    }

    public Calibration getQualityCalibration(GetQualityCalibrationRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Calibration>(){});
    }

    public ApiResponse<Calibration> getQualityCalibration(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Calibration>(){});
    }

    public CalibrationEntityListing getQualityCalibrations(String calibratorId, Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, String conversationId, Date startTime, Date endTime) throws ApiException {
        return this.getQualityCalibrationsWithHttpInfo(calibratorId, pageSize, pageNumber, sortBy, expand, nextPage, previousPage, conversationId, startTime, endTime).getBody();
    }

    public ApiResponse<CalibrationEntityListing> getQualityCalibrationsWithHttpInfo(String calibratorId, Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, String conversationId, Date startTime, Date endTime) throws ApiException {
        Object pclocalVarPostBody = null;
        if (calibratorId == null) {
            throw new ApiException(400, "Missing the required parameter 'calibratorId' when calling getQualityCalibrations");
        }
        String pclocalVarPath = "/api/v2/quality/calibrations".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortBy", sortBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "expand", expand));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "nextPage", nextPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "previousPage", previousPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "conversationId", conversationId));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "startTime", startTime));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "endTime", endTime));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "calibratorId", calibratorId));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<CalibrationEntityListing>(){});
    }

    public CalibrationEntityListing getQualityCalibrations(GetQualityCalibrationsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<CalibrationEntityListing>(){});
    }

    public ApiResponse<CalibrationEntityListing> getQualityCalibrations(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<CalibrationEntityListing>(){});
    }

    public QualityAuditPage getQualityConversationAudits(String conversationId, Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, String recordingId, String entityType) throws ApiException {
        return this.getQualityConversationAuditsWithHttpInfo(conversationId, pageSize, pageNumber, sortBy, expand, nextPage, previousPage, recordingId, entityType).getBody();
    }

    public ApiResponse<QualityAuditPage> getQualityConversationAuditsWithHttpInfo(String conversationId, Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, String recordingId, String entityType) throws ApiException {
        Object pclocalVarPostBody = null;
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling getQualityConversationAudits");
        }
        String pclocalVarPath = "/api/v2/quality/conversations/{conversationId}/audits".replaceAll("\\{format\\}", "json").replaceAll("\\{conversationId\\}", this.pcapiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortBy", sortBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "expand", expand));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "nextPage", nextPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "previousPage", previousPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "recordingId", recordingId));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "entityType", entityType));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<QualityAuditPage>(){});
    }

    public QualityAuditPage getQualityConversationAudits(GetQualityConversationAuditsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<QualityAuditPage>(){});
    }

    public ApiResponse<QualityAuditPage> getQualityConversationAudits(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<QualityAuditPage>(){});
    }

    public Evaluation getQualityConversationEvaluation(String conversationId, String evaluationId, String expand) throws ApiException {
        return this.getQualityConversationEvaluationWithHttpInfo(conversationId, evaluationId, expand).getBody();
    }

    public ApiResponse<Evaluation> getQualityConversationEvaluationWithHttpInfo(String conversationId, String evaluationId, String expand) throws ApiException {
        Object pclocalVarPostBody = null;
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling getQualityConversationEvaluation");
        }
        if (evaluationId == null) {
            throw new ApiException(400, "Missing the required parameter 'evaluationId' when calling getQualityConversationEvaluation");
        }
        String pclocalVarPath = "/api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId}".replaceAll("\\{format\\}", "json").replaceAll("\\{conversationId\\}", this.pcapiClient.escapeString(conversationId.toString())).replaceAll("\\{evaluationId\\}", this.pcapiClient.escapeString(evaluationId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "expand", expand));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Evaluation>(){});
    }

    public Evaluation getQualityConversationEvaluation(GetQualityConversationEvaluationRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Evaluation>(){});
    }

    public ApiResponse<Evaluation> getQualityConversationEvaluation(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Evaluation>(){});
    }

    public EvaluationEntityListing getQualityEvaluationsQuery(Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, String conversationId, String agentUserId, String evaluatorUserId, String queueId, String startTime, String endTime, List<Object> evaluationState, Boolean isReleased, Boolean agentHasRead, Boolean expandAnswerTotalScores, Integer maximum) throws ApiException {
        return this.getQualityEvaluationsQueryWithHttpInfo(pageSize, pageNumber, sortBy, expand, nextPage, previousPage, conversationId, agentUserId, evaluatorUserId, queueId, startTime, endTime, evaluationState, isReleased, agentHasRead, expandAnswerTotalScores, maximum).getBody();
    }

    public ApiResponse<EvaluationEntityListing> getQualityEvaluationsQueryWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, String conversationId, String agentUserId, String evaluatorUserId, String queueId, String startTime, String endTime, List<Object> evaluationState, Boolean isReleased, Boolean agentHasRead, Boolean expandAnswerTotalScores, Integer maximum) throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/quality/evaluations/query".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortBy", sortBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "expand", expand));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "nextPage", nextPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "previousPage", previousPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "conversationId", conversationId));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "agentUserId", agentUserId));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "evaluatorUserId", evaluatorUserId));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "queueId", queueId));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "startTime", startTime));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "endTime", endTime));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "evaluationState", evaluationState));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "isReleased", isReleased));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "agentHasRead", agentHasRead));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "expandAnswerTotalScores", expandAnswerTotalScores));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "maximum", maximum));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<EvaluationEntityListing>(){});
    }

    public EvaluationEntityListing getQualityEvaluationsQuery(GetQualityEvaluationsQueryRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<EvaluationEntityListing>(){});
    }

    public ApiResponse<EvaluationEntityListing> getQualityEvaluationsQuery(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<EvaluationEntityListing>(){});
    }

    public EvaluatorActivityEntityListing getQualityEvaluatorsActivity(Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, Date startTime, Date endTime, String name, List<Object> permission, String group) throws ApiException {
        return this.getQualityEvaluatorsActivityWithHttpInfo(pageSize, pageNumber, sortBy, expand, nextPage, previousPage, startTime, endTime, name, permission, group).getBody();
    }

    public ApiResponse<EvaluatorActivityEntityListing> getQualityEvaluatorsActivityWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, Date startTime, Date endTime, String name, List<Object> permission, String group) throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/quality/evaluators/activity".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortBy", sortBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "expand", expand));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "nextPage", nextPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "previousPage", previousPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "startTime", startTime));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "endTime", endTime));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "name", name));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "permission", permission));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "group", group));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<EvaluatorActivityEntityListing>(){});
    }

    public EvaluatorActivityEntityListing getQualityEvaluatorsActivity(GetQualityEvaluatorsActivityRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<EvaluatorActivityEntityListing>(){});
    }

    public ApiResponse<EvaluatorActivityEntityListing> getQualityEvaluatorsActivity(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<EvaluatorActivityEntityListing>(){});
    }

    public EvaluationForm getQualityForm(String formId) throws ApiException {
        return this.getQualityFormWithHttpInfo(formId).getBody();
    }

    public ApiResponse<EvaluationForm> getQualityFormWithHttpInfo(String formId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (formId == null) {
            throw new ApiException(400, "Missing the required parameter 'formId' when calling getQualityForm");
        }
        String pclocalVarPath = "/api/v2/quality/forms/{formId}".replaceAll("\\{format\\}", "json").replaceAll("\\{formId\\}", this.pcapiClient.escapeString(formId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<EvaluationForm>(){});
    }

    public EvaluationForm getQualityForm(GetQualityFormRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<EvaluationForm>(){});
    }

    public ApiResponse<EvaluationForm> getQualityForm(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<EvaluationForm>(){});
    }

    public EvaluationFormEntityListing getQualityFormVersions(String formId, Integer pageSize, Integer pageNumber) throws ApiException {
        return this.getQualityFormVersionsWithHttpInfo(formId, pageSize, pageNumber).getBody();
    }

    public ApiResponse<EvaluationFormEntityListing> getQualityFormVersionsWithHttpInfo(String formId, Integer pageSize, Integer pageNumber) throws ApiException {
        Object pclocalVarPostBody = null;
        if (formId == null) {
            throw new ApiException(400, "Missing the required parameter 'formId' when calling getQualityFormVersions");
        }
        String pclocalVarPath = "/api/v2/quality/forms/{formId}/versions".replaceAll("\\{format\\}", "json").replaceAll("\\{formId\\}", this.pcapiClient.escapeString(formId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<EvaluationFormEntityListing>(){});
    }

    public EvaluationFormEntityListing getQualityFormVersions(GetQualityFormVersionsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<EvaluationFormEntityListing>(){});
    }

    public ApiResponse<EvaluationFormEntityListing> getQualityFormVersions(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<EvaluationFormEntityListing>(){});
    }

    public EvaluationFormEntityListing getQualityForms(Integer pageSize, Integer pageNumber, String sortBy, String nextPage, String previousPage, String expand, String name) throws ApiException {
        return this.getQualityFormsWithHttpInfo(pageSize, pageNumber, sortBy, nextPage, previousPage, expand, name).getBody();
    }

    public ApiResponse<EvaluationFormEntityListing> getQualityFormsWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, String nextPage, String previousPage, String expand, String name) throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/quality/forms".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortBy", sortBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "nextPage", nextPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "previousPage", previousPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "expand", expand));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "name", name));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<EvaluationFormEntityListing>(){});
    }

    public EvaluationFormEntityListing getQualityForms(GetQualityFormsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<EvaluationFormEntityListing>(){});
    }

    public ApiResponse<EvaluationFormEntityListing> getQualityForms(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<EvaluationFormEntityListing>(){});
    }

    public KeywordSet getQualityKeywordset(String keywordSetId) throws ApiException {
        return this.getQualityKeywordsetWithHttpInfo(keywordSetId).getBody();
    }

    public ApiResponse<KeywordSet> getQualityKeywordsetWithHttpInfo(String keywordSetId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (keywordSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'keywordSetId' when calling getQualityKeywordset");
        }
        String pclocalVarPath = "/api/v2/quality/keywordsets/{keywordSetId}".replaceAll("\\{format\\}", "json").replaceAll("\\{keywordSetId\\}", this.pcapiClient.escapeString(keywordSetId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<KeywordSet>(){});
    }

    public KeywordSet getQualityKeywordset(GetQualityKeywordsetRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<KeywordSet>(){});
    }

    public ApiResponse<KeywordSet> getQualityKeywordset(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<KeywordSet>(){});
    }

    public KeywordSetEntityListing getQualityKeywordsets(Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, String name, String queueId, String agentId, String operator) throws ApiException {
        return this.getQualityKeywordsetsWithHttpInfo(pageSize, pageNumber, sortBy, expand, nextPage, previousPage, name, queueId, agentId, operator).getBody();
    }

    public ApiResponse<KeywordSetEntityListing> getQualityKeywordsetsWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, String name, String queueId, String agentId, String operator) throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/quality/keywordsets".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortBy", sortBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "expand", expand));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "nextPage", nextPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "previousPage", previousPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "name", name));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "queueId", queueId));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "agentId", agentId));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "operator", operator));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<KeywordSetEntityListing>(){});
    }

    public KeywordSetEntityListing getQualityKeywordsets(GetQualityKeywordsetsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<KeywordSetEntityListing>(){});
    }

    public ApiResponse<KeywordSetEntityListing> getQualityKeywordsets(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<KeywordSetEntityListing>(){});
    }

    public EvaluationForm getQualityPublishedform(String formId) throws ApiException {
        return this.getQualityPublishedformWithHttpInfo(formId).getBody();
    }

    public ApiResponse<EvaluationForm> getQualityPublishedformWithHttpInfo(String formId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (formId == null) {
            throw new ApiException(400, "Missing the required parameter 'formId' when calling getQualityPublishedform");
        }
        String pclocalVarPath = "/api/v2/quality/publishedforms/{formId}".replaceAll("\\{format\\}", "json").replaceAll("\\{formId\\}", this.pcapiClient.escapeString(formId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<EvaluationForm>(){});
    }

    public EvaluationForm getQualityPublishedform(GetQualityPublishedformRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<EvaluationForm>(){});
    }

    public ApiResponse<EvaluationForm> getQualityPublishedform(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<EvaluationForm>(){});
    }

    public EvaluationFormEntityListing getQualityPublishedforms(Integer pageSize, Integer pageNumber, String name) throws ApiException {
        return this.getQualityPublishedformsWithHttpInfo(pageSize, pageNumber, name).getBody();
    }

    public ApiResponse<EvaluationFormEntityListing> getQualityPublishedformsWithHttpInfo(Integer pageSize, Integer pageNumber, String name) throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/quality/publishedforms".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "name", name));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<EvaluationFormEntityListing>(){});
    }

    public EvaluationFormEntityListing getQualityPublishedforms(GetQualityPublishedformsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<EvaluationFormEntityListing>(){});
    }

    public ApiResponse<EvaluationFormEntityListing> getQualityPublishedforms(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<EvaluationFormEntityListing>(){});
    }

    public AggregateQueryResponse postAnalyticsEvaluationsAggregatesQuery(AggregationQuery body) throws ApiException {
        return this.postAnalyticsEvaluationsAggregatesQueryWithHttpInfo(body).getBody();
    }

    public ApiResponse<AggregateQueryResponse> postAnalyticsEvaluationsAggregatesQueryWithHttpInfo(AggregationQuery body) throws ApiException {
        AggregationQuery pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postAnalyticsEvaluationsAggregatesQuery");
        }
        String pclocalVarPath = "/api/v2/analytics/evaluations/aggregates/query".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<AggregateQueryResponse>(){});
    }

    public AggregateQueryResponse postAnalyticsEvaluationsAggregatesQuery(PostAnalyticsEvaluationsAggregatesQueryRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<AggregateQueryResponse>(){});
    }

    public ApiResponse<AggregateQueryResponse> postAnalyticsEvaluationsAggregatesQuery(ApiRequest<AggregationQuery> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<AggregateQueryResponse>(){});
    }

    public Calibration postQualityCalibrations(CalibrationCreate body, String expand) throws ApiException {
        return this.postQualityCalibrationsWithHttpInfo(body, expand).getBody();
    }

    public ApiResponse<Calibration> postQualityCalibrationsWithHttpInfo(CalibrationCreate body, String expand) throws ApiException {
        CalibrationCreate pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postQualityCalibrations");
        }
        String pclocalVarPath = "/api/v2/quality/calibrations".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "expand", expand));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Calibration>(){});
    }

    public Calibration postQualityCalibrations(PostQualityCalibrationsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Calibration>(){});
    }

    public ApiResponse<Calibration> postQualityCalibrations(ApiRequest<CalibrationCreate> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Calibration>(){});
    }

    public Evaluation postQualityConversationEvaluations(String conversationId, Evaluation body, String expand) throws ApiException {
        return this.postQualityConversationEvaluationsWithHttpInfo(conversationId, body, expand).getBody();
    }

    public ApiResponse<Evaluation> postQualityConversationEvaluationsWithHttpInfo(String conversationId, Evaluation body, String expand) throws ApiException {
        Evaluation pclocalVarPostBody = body;
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling postQualityConversationEvaluations");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postQualityConversationEvaluations");
        }
        String pclocalVarPath = "/api/v2/quality/conversations/{conversationId}/evaluations".replaceAll("\\{format\\}", "json").replaceAll("\\{conversationId\\}", this.pcapiClient.escapeString(conversationId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "expand", expand));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Evaluation>(){});
    }

    public Evaluation postQualityConversationEvaluations(PostQualityConversationEvaluationsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Evaluation>(){});
    }

    public ApiResponse<Evaluation> postQualityConversationEvaluations(ApiRequest<Evaluation> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Evaluation>(){});
    }

    public EvaluationScoringSet postQualityEvaluationsScoring(EvaluationFormAndScoringSet body) throws ApiException {
        return this.postQualityEvaluationsScoringWithHttpInfo(body).getBody();
    }

    public ApiResponse<EvaluationScoringSet> postQualityEvaluationsScoringWithHttpInfo(EvaluationFormAndScoringSet body) throws ApiException {
        EvaluationFormAndScoringSet pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postQualityEvaluationsScoring");
        }
        String pclocalVarPath = "/api/v2/quality/evaluations/scoring".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<EvaluationScoringSet>(){});
    }

    public EvaluationScoringSet postQualityEvaluationsScoring(PostQualityEvaluationsScoringRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<EvaluationScoringSet>(){});
    }

    public ApiResponse<EvaluationScoringSet> postQualityEvaluationsScoring(ApiRequest<EvaluationFormAndScoringSet> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<EvaluationScoringSet>(){});
    }

    public EvaluationForm postQualityForms(EvaluationForm body) throws ApiException {
        return this.postQualityFormsWithHttpInfo(body).getBody();
    }

    public ApiResponse<EvaluationForm> postQualityFormsWithHttpInfo(EvaluationForm body) throws ApiException {
        EvaluationForm pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postQualityForms");
        }
        String pclocalVarPath = "/api/v2/quality/forms".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<EvaluationForm>(){});
    }

    public EvaluationForm postQualityForms(PostQualityFormsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<EvaluationForm>(){});
    }

    public ApiResponse<EvaluationForm> postQualityForms(ApiRequest<EvaluationForm> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<EvaluationForm>(){});
    }

    public KeywordSet postQualityKeywordsets(KeywordSet body, String expand) throws ApiException {
        return this.postQualityKeywordsetsWithHttpInfo(body, expand).getBody();
    }

    public ApiResponse<KeywordSet> postQualityKeywordsetsWithHttpInfo(KeywordSet body, String expand) throws ApiException {
        KeywordSet pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postQualityKeywordsets");
        }
        String pclocalVarPath = "/api/v2/quality/keywordsets".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "expand", expand));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<KeywordSet>(){});
    }

    public KeywordSet postQualityKeywordsets(PostQualityKeywordsetsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<KeywordSet>(){});
    }

    public ApiResponse<KeywordSet> postQualityKeywordsets(ApiRequest<KeywordSet> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<KeywordSet>(){});
    }

    public EvaluationForm postQualityPublishedforms(EvaluationForm body) throws ApiException {
        return this.postQualityPublishedformsWithHttpInfo(body).getBody();
    }

    public ApiResponse<EvaluationForm> postQualityPublishedformsWithHttpInfo(EvaluationForm body) throws ApiException {
        EvaluationForm pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postQualityPublishedforms");
        }
        String pclocalVarPath = "/api/v2/quality/publishedforms".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<EvaluationForm>(){});
    }

    public EvaluationForm postQualityPublishedforms(PostQualityPublishedformsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<EvaluationForm>(){});
    }

    public ApiResponse<EvaluationForm> postQualityPublishedforms(ApiRequest<EvaluationForm> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<EvaluationForm>(){});
    }

    public KeywordSet postQualitySpotability(KeywordSet body) throws ApiException {
        return this.postQualitySpotabilityWithHttpInfo(body).getBody();
    }

    public ApiResponse<KeywordSet> postQualitySpotabilityWithHttpInfo(KeywordSet body) throws ApiException {
        KeywordSet pclocalVarPostBody = body;
        String pclocalVarPath = "/api/v2/quality/spotability".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<KeywordSet>(){});
    }

    public KeywordSet postQualitySpotability(PostQualitySpotabilityRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<KeywordSet>(){});
    }

    public ApiResponse<KeywordSet> postQualitySpotability(ApiRequest<KeywordSet> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<KeywordSet>(){});
    }

    public Calibration putQualityCalibration(String calibrationId, Calibration body) throws ApiException {
        return this.putQualityCalibrationWithHttpInfo(calibrationId, body).getBody();
    }

    public ApiResponse<Calibration> putQualityCalibrationWithHttpInfo(String calibrationId, Calibration body) throws ApiException {
        Calibration pclocalVarPostBody = body;
        if (calibrationId == null) {
            throw new ApiException(400, "Missing the required parameter 'calibrationId' when calling putQualityCalibration");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling putQualityCalibration");
        }
        String pclocalVarPath = "/api/v2/quality/calibrations/{calibrationId}".replaceAll("\\{format\\}", "json").replaceAll("\\{calibrationId\\}", this.pcapiClient.escapeString(calibrationId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Calibration>(){});
    }

    public Calibration putQualityCalibration(PutQualityCalibrationRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Calibration>(){});
    }

    public ApiResponse<Calibration> putQualityCalibration(ApiRequest<Calibration> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Calibration>(){});
    }

    public Evaluation putQualityConversationEvaluation(String conversationId, String evaluationId, Evaluation body, String expand) throws ApiException {
        return this.putQualityConversationEvaluationWithHttpInfo(conversationId, evaluationId, body, expand).getBody();
    }

    public ApiResponse<Evaluation> putQualityConversationEvaluationWithHttpInfo(String conversationId, String evaluationId, Evaluation body, String expand) throws ApiException {
        Evaluation pclocalVarPostBody = body;
        if (conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when calling putQualityConversationEvaluation");
        }
        if (evaluationId == null) {
            throw new ApiException(400, "Missing the required parameter 'evaluationId' when calling putQualityConversationEvaluation");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling putQualityConversationEvaluation");
        }
        String pclocalVarPath = "/api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId}".replaceAll("\\{format\\}", "json").replaceAll("\\{conversationId\\}", this.pcapiClient.escapeString(conversationId.toString())).replaceAll("\\{evaluationId\\}", this.pcapiClient.escapeString(evaluationId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "expand", expand));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Evaluation>(){});
    }

    public Evaluation putQualityConversationEvaluation(PutQualityConversationEvaluationRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Evaluation>(){});
    }

    public ApiResponse<Evaluation> putQualityConversationEvaluation(ApiRequest<Evaluation> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Evaluation>(){});
    }

    public EvaluationForm putQualityForm(String formId, EvaluationForm body) throws ApiException {
        return this.putQualityFormWithHttpInfo(formId, body).getBody();
    }

    public ApiResponse<EvaluationForm> putQualityFormWithHttpInfo(String formId, EvaluationForm body) throws ApiException {
        EvaluationForm pclocalVarPostBody = body;
        if (formId == null) {
            throw new ApiException(400, "Missing the required parameter 'formId' when calling putQualityForm");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling putQualityForm");
        }
        String pclocalVarPath = "/api/v2/quality/forms/{formId}".replaceAll("\\{format\\}", "json").replaceAll("\\{formId\\}", this.pcapiClient.escapeString(formId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<EvaluationForm>(){});
    }

    public EvaluationForm putQualityForm(PutQualityFormRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<EvaluationForm>(){});
    }

    public ApiResponse<EvaluationForm> putQualityForm(ApiRequest<EvaluationForm> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<EvaluationForm>(){});
    }

    public KeywordSet putQualityKeywordset(String keywordSetId, KeywordSet body) throws ApiException {
        return this.putQualityKeywordsetWithHttpInfo(keywordSetId, body).getBody();
    }

    public ApiResponse<KeywordSet> putQualityKeywordsetWithHttpInfo(String keywordSetId, KeywordSet body) throws ApiException {
        KeywordSet pclocalVarPostBody = body;
        if (keywordSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'keywordSetId' when calling putQualityKeywordset");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling putQualityKeywordset");
        }
        String pclocalVarPath = "/api/v2/quality/keywordsets/{keywordSetId}".replaceAll("\\{format\\}", "json").replaceAll("\\{keywordSetId\\}", this.pcapiClient.escapeString(keywordSetId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<KeywordSet>(){});
    }

    public KeywordSet putQualityKeywordset(PutQualityKeywordsetRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<KeywordSet>(){});
    }

    public ApiResponse<KeywordSet> putQualityKeywordset(ApiRequest<KeywordSet> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<KeywordSet>(){});
    }
}

