/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetConversationsChatParticipantWrapupRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String chatId;
    private String participantId;
    private Boolean provisional;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public GetConversationsChatParticipantWrapupRequest withChatId(String chatId) {
        this.setChatId(chatId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public GetConversationsChatParticipantWrapupRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public Boolean getProvisional() {
        return this.provisional;
    }

    public void setProvisional(Boolean provisional) {
        this.provisional = provisional;
    }

    public GetConversationsChatParticipantWrapupRequest withProvisional(Boolean provisional) {
        this.setProvisional(provisional);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetConversationsChatParticipantWrapupRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() throws ApiException {
        if (this.chatId == null) {
            throw new ApiException(400, "Missing the required parameter 'chatId' when building request for GetConversationsChatParticipantWrapupRequest.");
        }
        if (this.participantId == null) {
            throw new ApiException(400, "Missing the required parameter 'participantId' when building request for GetConversationsChatParticipantWrapupRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapup").withPathParameter("chatId", this.chatId).withPathParameter("participantId", this.participantId).withQueryParameters("provisional", "", this.provisional).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String chatId, String participantId) {
        return new Builder().withRequiredParams(chatId, participantId);
    }

    public static class Builder {
        private final GetConversationsChatParticipantWrapupRequest request = new GetConversationsChatParticipantWrapupRequest();

        private Builder() {
        }

        public Builder withChatId(String chatId) {
            this.request.setChatId(chatId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withProvisional(Boolean provisional) {
            this.request.setProvisional(provisional);
            return this;
        }

        public Builder withRequiredParams(String chatId, String participantId) {
            this.request.setChatId(chatId);
            this.request.setParticipantId(participantId);
            return this;
        }

        public GetConversationsChatParticipantWrapupRequest build() {
            return this.request;
        }
    }
}

