/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.connector.okhttp;

import com.mypurecloud.sdk.v2.connector.ApiClientConnector;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorProperties;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorProperty;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorProvider;
import com.mypurecloud.sdk.v2.connector.okhttp.OkHttpClientConnector;
import com.squareup.okhttp.Dispatcher;
import com.squareup.okhttp.OkHttpClient;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class OkHttpClientConnectorProvider
implements ApiClientConnectorProvider {
    @Override
    public ApiClientConnector create(ApiClientConnectorProperties properties) {
        ExecutorService executorService;
        OkHttpClient client = new OkHttpClient();
        Integer connectionTimeout = properties.getProperty(ApiClientConnectorProperty.CONNECTION_TIMEOUT, Integer.class, null);
        if (connectionTimeout != null && connectionTimeout > 0) {
            client.setConnectTimeout((long)connectionTimeout.intValue(), TimeUnit.MILLISECONDS);
            client.setReadTimeout((long)connectionTimeout.intValue(), TimeUnit.MILLISECONDS);
            client.setWriteTimeout((long)connectionTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
        if ((executorService = (ExecutorService)properties.getProperty(ApiClientConnectorProperty.ASYNC_EXECUTOR_SERVICE, ExecutorService.class, null)) != null) {
            client.setDispatcher(new Dispatcher(executorService));
        }
        return new OkHttpClientConnector(client);
    }
}

