/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.DocumentationSearchRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PostDocumentationSearchRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private DocumentationSearchRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public DocumentationSearchRequest getBody() {
        return this.body;
    }

    public void setBody(DocumentationSearchRequest body) {
        this.body = body;
    }

    public PostDocumentationSearchRequest withBody(DocumentationSearchRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostDocumentationSearchRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<DocumentationSearchRequest> withHttpInfo() throws ApiException {
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PostDocumentationSearchRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/documentation/search").withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DocumentationSearchRequest body) {
        return new Builder().withRequiredParams(body);
    }

    public static class Builder {
        private final PostDocumentationSearchRequest request = new PostDocumentationSearchRequest();

        private Builder() {
        }

        public Builder withBody(DocumentationSearchRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(DocumentationSearchRequest body) {
            this.request.setBody(body);
            return this;
        }

        public PostDocumentationSearchRequest build() {
            return this.request;
        }
    }
}

