/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ParticipantAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PatchConversationsEmailParticipantAttributesRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String emailId;
    private String participantId;
    private ParticipantAttributes body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public PatchConversationsEmailParticipantAttributesRequest withEmailId(String emailId) {
        this.setEmailId(emailId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public PatchConversationsEmailParticipantAttributesRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public ParticipantAttributes getBody() {
        return this.body;
    }

    public void setBody(ParticipantAttributes body) {
        this.body = body;
    }

    public PatchConversationsEmailParticipantAttributesRequest withBody(ParticipantAttributes body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchConversationsEmailParticipantAttributesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ParticipantAttributes> withHttpInfo() throws ApiException {
        if (this.emailId == null) {
            throw new ApiException(400, "Missing the required parameter 'emailId' when building request for PatchConversationsEmailParticipantAttributesRequest.");
        }
        if (this.participantId == null) {
            throw new ApiException(400, "Missing the required parameter 'participantId' when building request for PatchConversationsEmailParticipantAttributesRequest.");
        }
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PatchConversationsEmailParticipantAttributesRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/conversations/emails/{emailId}/participants/{participantId}/attributes").withPathParameter("emailId", this.emailId).withPathParameter("participantId", this.participantId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String emailId, String participantId, ParticipantAttributes body) {
        return new Builder().withRequiredParams(emailId, participantId, body);
    }

    public static class Builder {
        private final PatchConversationsEmailParticipantAttributesRequest request = new PatchConversationsEmailParticipantAttributesRequest();

        private Builder() {
        }

        public Builder withEmailId(String emailId) {
            this.request.setEmailId(emailId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withBody(ParticipantAttributes body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String emailId, String participantId, ParticipantAttributes body) {
            this.request.setEmailId(emailId);
            this.request.setParticipantId(participantId);
            this.request.setBody(body);
            return this;
        }

        public PatchConversationsEmailParticipantAttributesRequest build() {
            return this.request;
        }
    }
}

