/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetQualityConversationEvaluationRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String conversationId;
    private String evaluationId;
    private String expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public GetQualityConversationEvaluationRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getEvaluationId() {
        return this.evaluationId;
    }

    public void setEvaluationId(String evaluationId) {
        this.evaluationId = evaluationId;
    }

    public GetQualityConversationEvaluationRequest withEvaluationId(String evaluationId) {
        this.setEvaluationId(evaluationId);
        return this;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public GetQualityConversationEvaluationRequest withExpand(String expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetQualityConversationEvaluationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() throws ApiException {
        if (this.conversationId == null) {
            throw new ApiException(400, "Missing the required parameter 'conversationId' when building request for GetQualityConversationEvaluationRequest.");
        }
        if (this.evaluationId == null) {
            throw new ApiException(400, "Missing the required parameter 'evaluationId' when building request for GetQualityConversationEvaluationRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId}").withPathParameter("conversationId", this.conversationId).withPathParameter("evaluationId", this.evaluationId).withQueryParameters("expand", "", this.expand).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String evaluationId) {
        return new Builder().withRequiredParams(conversationId, evaluationId);
    }

    public static class Builder {
        private final GetQualityConversationEvaluationRequest request = new GetQualityConversationEvaluationRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withEvaluationId(String evaluationId) {
            this.request.setEvaluationId(evaluationId);
            return this;
        }

        public Builder withExpand(String expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String evaluationId) {
            this.request.setConversationId(conversationId);
            this.request.setEvaluationId(evaluationId);
            return this;
        }

        public GetQualityConversationEvaluationRequest build() {
            return this.request;
        }
    }
}

