/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetLocationRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String locationId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public GetLocationRequest withLocationId(String locationId) {
        this.setLocationId(locationId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetLocationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() throws ApiException {
        if (this.locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when building request for GetLocationRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/locations/{locationId}").withPathParameter("locationId", this.locationId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String locationId) {
        return new Builder().withRequiredParams(locationId);
    }

    public static class Builder {
        private final GetLocationRequest request = new GetLocationRequest();

        private Builder() {
        }

        public Builder withLocationId(String locationId) {
            this.request.setLocationId(locationId);
            return this;
        }

        public Builder withRequiredParams(String locationId) {
            this.request.setLocationId(locationId);
            return this;
        }

        public GetLocationRequest build() {
            return this.request;
        }
    }
}

