/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class DeleteOutboundRulesetRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String ruleSetId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRuleSetId() {
        return this.ruleSetId;
    }

    public void setRuleSetId(String ruleSetId) {
        this.ruleSetId = ruleSetId;
    }

    public DeleteOutboundRulesetRequest withRuleSetId(String ruleSetId) {
        this.setRuleSetId(ruleSetId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteOutboundRulesetRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() throws ApiException {
        if (this.ruleSetId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleSetId' when building request for DeleteOutboundRulesetRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/outbound/rulesets/{ruleSetId}").withPathParameter("ruleSetId", this.ruleSetId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String ruleSetId) {
        return new Builder().withRequiredParams(ruleSetId);
    }

    public static class Builder {
        private final DeleteOutboundRulesetRequest request = new DeleteOutboundRulesetRequest();

        private Builder() {
        }

        public Builder withRuleSetId(String ruleSetId) {
            this.request.setRuleSetId(ruleSetId);
            return this;
        }

        public Builder withRequiredParams(String ruleSetId) {
            this.request.setRuleSetId(ruleSetId);
            return this;
        }

        public DeleteOutboundRulesetRequest build() {
            return this.request;
        }
    }
}

