/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.DeleteLanguageRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteRoutingLanguageRequest;
import com.mypurecloud.sdk.v2.api.request.GetLanguageRequest;
import com.mypurecloud.sdk.v2.api.request.GetLanguagesRequest;
import com.mypurecloud.sdk.v2.api.request.GetLanguagesTranslationsBuiltinRequest;
import com.mypurecloud.sdk.v2.api.request.GetLanguagesTranslationsOrganizationRequest;
import com.mypurecloud.sdk.v2.api.request.GetLanguagesTranslationsRequest;
import com.mypurecloud.sdk.v2.api.request.GetLanguagesTranslationsUserRequest;
import com.mypurecloud.sdk.v2.api.request.GetRoutingLanguageRequest;
import com.mypurecloud.sdk.v2.api.request.PostLanguagesRequest;
import com.mypurecloud.sdk.v2.model.AvailableTranslations;
import com.mypurecloud.sdk.v2.model.Language;
import com.mypurecloud.sdk.v2.model.LanguageEntityListing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LanguagesApi {
    private final ApiClient pcapiClient;

    public LanguagesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LanguagesApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteLanguage(String languageId) throws ApiException {
        this.deleteLanguageWithHttpInfo(languageId);
    }

    public ApiResponse<Void> deleteLanguageWithHttpInfo(String languageId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (languageId == null) {
            throw new ApiException(400, "Missing the required parameter 'languageId' when calling deleteLanguage");
        }
        String pclocalVarPath = "/api/v2/languages/{languageId}".replaceAll("\\{format\\}", "json").replaceAll("\\{languageId\\}", this.pcapiClient.escapeString(languageId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, null);
    }

    public void deleteLanguage(DeleteLanguageRequest request) throws ApiException {
        this.pcapiClient.invokeAPI(request.withHttpInfo(), null);
    }

    public ApiResponse<Void> deleteLanguage(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, null);
    }

    public void deleteRoutingLanguage(String languageId) throws ApiException {
        this.deleteRoutingLanguageWithHttpInfo(languageId);
    }

    public ApiResponse<Void> deleteRoutingLanguageWithHttpInfo(String languageId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (languageId == null) {
            throw new ApiException(400, "Missing the required parameter 'languageId' when calling deleteRoutingLanguage");
        }
        String pclocalVarPath = "/api/v2/routing/languages/{languageId}".replaceAll("\\{format\\}", "json").replaceAll("\\{languageId\\}", this.pcapiClient.escapeString(languageId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, null);
    }

    public void deleteRoutingLanguage(DeleteRoutingLanguageRequest request) throws ApiException {
        this.pcapiClient.invokeAPI(request.withHttpInfo(), null);
    }

    public ApiResponse<Void> deleteRoutingLanguage(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, null);
    }

    public Language getLanguage(String languageId) throws ApiException {
        return this.getLanguageWithHttpInfo(languageId).getBody();
    }

    public ApiResponse<Language> getLanguageWithHttpInfo(String languageId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (languageId == null) {
            throw new ApiException(400, "Missing the required parameter 'languageId' when calling getLanguage");
        }
        String pclocalVarPath = "/api/v2/languages/{languageId}".replaceAll("\\{format\\}", "json").replaceAll("\\{languageId\\}", this.pcapiClient.escapeString(languageId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Language>(){});
    }

    public Language getLanguage(GetLanguageRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Language>(){});
    }

    public ApiResponse<Language> getLanguage(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Language>(){});
    }

    public LanguageEntityListing getLanguages(Integer pageSize, Integer pageNumber, String sortOrder, String name) throws ApiException {
        return this.getLanguagesWithHttpInfo(pageSize, pageNumber, sortOrder, name).getBody();
    }

    public ApiResponse<LanguageEntityListing> getLanguagesWithHttpInfo(Integer pageSize, Integer pageNumber, String sortOrder, String name) throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/languages".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortOrder", sortOrder));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "name", name));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<LanguageEntityListing>(){});
    }

    public LanguageEntityListing getLanguages(GetLanguagesRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<LanguageEntityListing>(){});
    }

    public ApiResponse<LanguageEntityListing> getLanguages(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<LanguageEntityListing>(){});
    }

    public AvailableTranslations getLanguagesTranslations() throws ApiException {
        return this.getLanguagesTranslationsWithHttpInfo().getBody();
    }

    public ApiResponse<AvailableTranslations> getLanguagesTranslationsWithHttpInfo() throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/languages/translations".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<AvailableTranslations>(){});
    }

    public AvailableTranslations getLanguagesTranslations(GetLanguagesTranslationsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<AvailableTranslations>(){});
    }

    public ApiResponse<AvailableTranslations> getLanguagesTranslations(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<AvailableTranslations>(){});
    }

    public Map<String, Object> getLanguagesTranslationsBuiltin(String language) throws ApiException {
        return this.getLanguagesTranslationsBuiltinWithHttpInfo(language).getBody();
    }

    public ApiResponse<Map<String, Object>> getLanguagesTranslationsBuiltinWithHttpInfo(String language) throws ApiException {
        Object pclocalVarPostBody = null;
        if (language == null) {
            throw new ApiException(400, "Missing the required parameter 'language' when calling getLanguagesTranslationsBuiltin");
        }
        String pclocalVarPath = "/api/v2/languages/translations/builtin".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "language", language));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Map<String, Object>>(){});
    }

    public Map<String, Object> getLanguagesTranslationsBuiltin(GetLanguagesTranslationsBuiltinRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Map<String, Object>>(){});
    }

    public ApiResponse<Map<String, Object>> getLanguagesTranslationsBuiltin(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Map<String, Object>>(){});
    }

    public Map<String, Object> getLanguagesTranslationsOrganization(String language) throws ApiException {
        return this.getLanguagesTranslationsOrganizationWithHttpInfo(language).getBody();
    }

    public ApiResponse<Map<String, Object>> getLanguagesTranslationsOrganizationWithHttpInfo(String language) throws ApiException {
        Object pclocalVarPostBody = null;
        if (language == null) {
            throw new ApiException(400, "Missing the required parameter 'language' when calling getLanguagesTranslationsOrganization");
        }
        String pclocalVarPath = "/api/v2/languages/translations/organization".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "language", language));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Map<String, Object>>(){});
    }

    public Map<String, Object> getLanguagesTranslationsOrganization(GetLanguagesTranslationsOrganizationRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Map<String, Object>>(){});
    }

    public ApiResponse<Map<String, Object>> getLanguagesTranslationsOrganization(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Map<String, Object>>(){});
    }

    public Map<String, Object> getLanguagesTranslationsUser(String userId) throws ApiException {
        return this.getLanguagesTranslationsUserWithHttpInfo(userId).getBody();
    }

    public ApiResponse<Map<String, Object>> getLanguagesTranslationsUserWithHttpInfo(String userId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getLanguagesTranslationsUser");
        }
        String pclocalVarPath = "/api/v2/languages/translations/users/{userId}".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.pcapiClient.escapeString(userId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Map<String, Object>>(){});
    }

    public Map<String, Object> getLanguagesTranslationsUser(GetLanguagesTranslationsUserRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Map<String, Object>>(){});
    }

    public ApiResponse<Map<String, Object>> getLanguagesTranslationsUser(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Map<String, Object>>(){});
    }

    public Language getRoutingLanguage(String languageId) throws ApiException {
        return this.getRoutingLanguageWithHttpInfo(languageId).getBody();
    }

    public ApiResponse<Language> getRoutingLanguageWithHttpInfo(String languageId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (languageId == null) {
            throw new ApiException(400, "Missing the required parameter 'languageId' when calling getRoutingLanguage");
        }
        String pclocalVarPath = "/api/v2/routing/languages/{languageId}".replaceAll("\\{format\\}", "json").replaceAll("\\{languageId\\}", this.pcapiClient.escapeString(languageId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Language>(){});
    }

    public Language getRoutingLanguage(GetRoutingLanguageRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Language>(){});
    }

    public ApiResponse<Language> getRoutingLanguage(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Language>(){});
    }

    public Language postLanguages(Language body) throws ApiException {
        return this.postLanguagesWithHttpInfo(body).getBody();
    }

    public ApiResponse<Language> postLanguagesWithHttpInfo(Language body) throws ApiException {
        Language pclocalVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postLanguages");
        }
        String pclocalVarPath = "/api/v2/languages".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Language>(){});
    }

    public Language postLanguages(PostLanguagesRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Language>(){});
    }

    public ApiResponse<Language> postLanguages(ApiRequest<Language> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Language>(){});
    }
}

