/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.EditText;
import com.mylhyl.superdialog.auto.AutoUtils;

public class SuperEditText
extends EditText {
    private Paint mPaint;

    public SuperEditText(Context context) {
        this(context, null);
    }

    public SuperEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SuperEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public SuperEditText(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.requestFocus();
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setGravity(51);
        this.mPaint = new Paint();
        this.mPaint.setColor(-16777216);
        this.mPaint.setStrokeWidth(1.0f);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawLine(0.0f, 0.0f, (float)(this.getWidth() - 1), 0.0f, this.mPaint);
        canvas.drawLine(0.0f, 0.0f, 0.0f, (float)(this.getHeight() - 1), this.mPaint);
        canvas.drawLine((float)(this.getWidth() - 1), 0.0f, (float)(this.getWidth() - 1), (float)(this.getHeight() - 1), this.mPaint);
        canvas.drawLine(0.0f, (float)(this.getHeight() - 1), (float)(this.getWidth() - 1), (float)(this.getHeight() - 1), this.mPaint);
        super.onDraw(canvas);
    }

    public void setHeight(int pixels) {
        int dimenHeight = AutoUtils.scaleValue(pixels);
        super.setHeight(dimenHeight);
    }

    public void setTextSize(float size) {
        int dimenTextSize = AutoUtils.scaleValue((int)size);
        this.setTextSize(0, dimenTextSize);
    }
}

