/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.mylhyl.superdialog.SuperDialog;
import com.mylhyl.superdialog.callback.ProviderFooterNegative;
import com.mylhyl.superdialog.callback.ProviderFooterPositive;
import com.mylhyl.superdialog.callback.ProviderFooterPositiveInput;
import com.mylhyl.superdialog.res.drawable.BgBtn;
import com.mylhyl.superdialog.view.BodyInputView;
import com.mylhyl.superdialog.view.Controller;
import com.mylhyl.superdialog.view.DividerView;
import com.mylhyl.superdialog.view.SuperTextView;

class FooterView
extends LinearLayout {
    private ProviderFooterPositive mFooterPositive;
    private SuperTextView mPositiveButton;

    public FooterView(Context context, Controller.Params params) {
        super(context);
        this.init(params);
    }

    private void init(Controller.Params params) {
        final ProviderFooterNegative footerNegative = params.mFooterNegative;
        this.mFooterPositive = params.mFooterPositive;
        this.setOrientation(0);
        int radius = params.mRadius;
        if (footerNegative != null) {
            final SuperDialog.OnClickNegativeListener onNegativeListener = footerNegative.getOnNegativeListener();
            SuperTextView mNegativeButton = new SuperTextView(this.getContext());
            mNegativeButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
            mNegativeButton.setClickable(true);
            mNegativeButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    footerNegative.dismiss();
                    if (onNegativeListener != null) {
                        onNegativeListener.onClick(v);
                    }
                }
            });
            mNegativeButton.setText(footerNegative.getTitle());
            mNegativeButton.setTextSize(footerNegative.getTextSize());
            mNegativeButton.setTextColor(footerNegative.getTextColor());
            mNegativeButton.setHeight(footerNegative.getHeight());
            if (this.mFooterPositive != null) {
                mNegativeButton.setBackgroundDrawable((Drawable)new BgBtn(0, 0, 0, radius, params.mBackgroundColor));
            } else {
                mNegativeButton.setBackgroundDrawable((Drawable)new BgBtn(0, 0, radius, radius, params.mBackgroundColor));
            }
            this.addView((View)mNegativeButton);
        }
        if (footerNegative != null && this.mFooterPositive != null) {
            DividerView dividerView = new DividerView(this.getContext());
            this.addView(dividerView);
        }
        if (this.mFooterPositive != null) {
            final SuperDialog.OnClickPositiveListener onPositiveListener = this.mFooterPositive.getOnPositiveListener();
            this.mPositiveButton = new SuperTextView(this.getContext());
            this.mPositiveButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
            this.mPositiveButton.setClickable(true);
            if (onPositiveListener != null) {
                this.mPositiveButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        FooterView.this.mFooterPositive.dismiss();
                        if (onPositiveListener != null) {
                            onPositiveListener.onClick(v);
                        }
                    }
                });
            }
            this.mPositiveButton.setText(this.mFooterPositive.getTitle());
            this.mPositiveButton.setTextSize(this.mFooterPositive.getTextSize());
            this.mPositiveButton.setTextColor(this.mFooterPositive.getTextColor());
            this.mPositiveButton.setHeight(this.mFooterPositive.getHeight());
            if (footerNegative != null) {
                this.mPositiveButton.setBackgroundDrawable((Drawable)new BgBtn(0, 0, radius, 0, params.mBackgroundColor));
            } else {
                this.mPositiveButton.setBackgroundDrawable((Drawable)new BgBtn(0, 0, radius, radius, params.mBackgroundColor));
            }
            this.addView((View)this.mPositiveButton);
        }
    }

    public void setOnClickPositiveInputListener(final BodyInputView inputView) {
        if (this.mFooterPositive != null && this.mFooterPositive instanceof ProviderFooterPositiveInput) {
            ProviderFooterPositiveInput positiveInput = (ProviderFooterPositiveInput)this.mFooterPositive;
            final SuperDialog.OnClickPositiveInputListener onPositiveInputListener = positiveInput.getOnPositiveInputListener();
            this.mPositiveButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String text = inputView.getInputText();
                    if (!TextUtils.isEmpty((CharSequence)text)) {
                        FooterView.this.mFooterPositive.dismiss();
                    }
                    if (onPositiveInputListener != null) {
                        onPositiveInputListener.onClick(text, v);
                    }
                }
            });
        }
    }
}

