/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog.view;

import android.content.Context;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.animation.Animation;
import com.mylhyl.superdialog.SuperDialog;
import com.mylhyl.superdialog.callback.CreateLayout;
import com.mylhyl.superdialog.callback.ProviderContent;
import com.mylhyl.superdialog.callback.ProviderContentInput;
import com.mylhyl.superdialog.callback.ProviderContentMultiple;
import com.mylhyl.superdialog.callback.ProviderContentSingle;
import com.mylhyl.superdialog.callback.ProviderFooterNegative;
import com.mylhyl.superdialog.callback.ProviderFooterPositive;
import com.mylhyl.superdialog.callback.ProviderFooterPositiveInput;
import com.mylhyl.superdialog.callback.ProviderHeader;
import com.mylhyl.superdialog.res.values.DimenRes;
import com.mylhyl.superdialog.view.BodyMultipleView;
import com.mylhyl.superdialog.view.BodySingleView;
import com.mylhyl.superdialog.view.CreateLayoutImpl;
import java.io.Serializable;

public final class Controller {
    private Context mContext;
    private Params mParams;
    private CreateLayout createLayout;

    public Controller(Params params) {
        this.mContext = params.mActivity.getApplicationContext();
        this.mParams = params;
    }

    public void apply() {
        ProviderContent providerContent;
        this.createLayout = new CreateLayoutImpl(this.mContext, this.mParams);
        if (this.mParams.mProviderHeader != null) {
            this.createLayout.buildHead();
        }
        if ((providerContent = this.mParams.mProviderContent) != null && providerContent.getMode() == ProviderContent.Mode.MULTIPLE) {
            this.createLayout.buildMultipleBody();
            if (this.mParams.mFooterNegative != null || this.mParams.mFooterPositive != null) {
                this.createLayout.buildMultipleFooter();
            }
        } else if (providerContent != null && providerContent.getMode() == ProviderContent.Mode.SINGLE) {
            this.createLayout.buildSingleBody();
            if (this.mParams.mFooterNegative != null || this.mParams.mFooterPositive != null) {
                this.createLayout.buildSingleFooter();
            }
        } else {
            View inputBody = this.createLayout.buildInputBody();
            if (this.mParams.mFooterNegative != null || this.mParams.mFooterPositive != null) {
                this.createLayout.buildInputFooter(inputBody);
            }
        }
    }

    public View createView() {
        return this.createLayout.buildView();
    }

    public void refreshProviderContent(Animation animation) {
        BodySingleView singleBody;
        ProviderContent providerContent = this.mParams.mProviderContent;
        if (providerContent != null && providerContent.getMode() == ProviderContent.Mode.MULTIPLE) {
            BodyMultipleView multipleBody = (BodyMultipleView)this.createLayout.findMultipleBody();
            if (multipleBody != null) {
                multipleBody.refreshItems();
            }
        } else if (providerContent != null && providerContent.getMode() == ProviderContent.Mode.SINGLE && (singleBody = (BodySingleView)this.createLayout.findSingleBody()) != null) {
            singleBody.refreshText();
        }
        if (animation != null) {
            this.createView().startAnimation(animation);
        }
    }

    public static class Params
    implements Serializable {
        public DialogFragment mDialogFragment;
        public FragmentActivity mActivity;
        public ProviderHeader mProviderHeader;
        public ProviderContent mProviderContent;
        public ProviderFooterNegative mFooterNegative;
        public ProviderFooterPositive mFooterPositive;
        public int mGravity = 17;
        public boolean mCanceledOnTouchOutside = true;
        public boolean mCancelable = true;
        public int mRadius = 30;
        public float mAlpha = 1.0f;
        public int mBackgroundColor = -460552;
        public float mWidth = 0.9f;
        public int[] mPadding;
        public int mItemsBottomMargin = 10;
        public View mAsDropDownAnchor = null;
        public int mAtLocationGravity = 0;
        public int mAnimStyle;
        public int x;
        public int y;
        public boolean isDimEnabled = true;
        public SuperDialog.ConfigDialog mConfigDialog;

        public Params(FragmentActivity activity) {
            this.mActivity = activity;
        }

        private void setProviderHeader(ProviderHeader providerHeader) {
            this.mProviderHeader = providerHeader;
        }

        private void setProviderContent(ProviderContent providerContent) {
            this.mProviderContent = providerContent;
        }

        private void setProviderFooterNegative(ProviderFooterNegative footerNegative) {
            this.mFooterNegative = footerNegative;
        }

        private void setProviderFooterPositive(ProviderFooterPositive footerPositive) {
            this.mFooterPositive = footerPositive;
        }

        public void setTitle(final String title, final int textColor, final int textSize, final int height) {
            this.setProviderHeader(new ProviderHeader(){

                @Override
                public String getTitle() {
                    return title;
                }

                @Override
                public int getTextColor() {
                    return textColor != 0 ? textColor : super.getTextColor();
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }

                @Override
                public int getHeight() {
                    return height > 0 ? height : super.getHeight();
                }
            });
        }

        public void setContentSingle(final String text, final int textColor, final int textSize, final int[] padding) {
            this.setProviderContent(new ProviderContentSingle(){

                @Override
                public int[] getPadding() {
                    return padding != null ? padding : DimenRes.contentPadding;
                }

                @Override
                public String getItems() {
                    return text;
                }

                @Override
                public int getTextColor() {
                    return textColor != 0 ? textColor : super.getTextColor();
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }
            });
        }

        public void setContentMultiple(final Object items, final int textColor, final int textSize, final int itemHeight, final SuperDialog.OnItemClickListener listener) {
            this.setProviderContent(new ProviderContentMultiple(){

                @Override
                public void dismiss() {
                    if (Params.this.mDialogFragment != null) {
                        Params.this.mDialogFragment.dismiss();
                    }
                }

                @Override
                public int getItemHeight() {
                    return itemHeight > 0 ? itemHeight : 170;
                }

                @Override
                public SuperDialog.OnItemClickListener getItemClickListener() {
                    return listener;
                }

                @Override
                public Object getItems() {
                    return items;
                }

                @Override
                public int getTextColor() {
                    return textColor != 0 ? textColor : super.getTextColor();
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }
            });
        }

        public void setContentInput(final String hint, final int textColor, final int textSize, final int inputHeight, final int[] margins) {
            this.setProviderContent(new ProviderContentInput(){

                @Override
                public int[] getMargins() {
                    return margins != null ? margins : DimenRes.contentMargins;
                }

                @Override
                public int getInputHeight() {
                    return inputHeight > 0 ? inputHeight : 340;
                }

                @Override
                public int getHintTextColor() {
                    return -7368817;
                }

                @Override
                public String getItems() {
                    return hint;
                }

                @Override
                public int getTextColor() {
                    return textColor != 0 ? textColor : -16777216;
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }
            });
        }

        public void setNegativeButton(final String text, final int textColor, final int textSize, final int height, final SuperDialog.OnClickNegativeListener listener) {
            this.setProviderFooterNegative(new ProviderFooterNegative(){

                @Override
                public String getTitle() {
                    return text;
                }

                @Override
                public void dismiss() {
                    if (Params.this.mDialogFragment != null) {
                        Params.this.mDialogFragment.dismiss();
                    }
                }

                @Override
                public SuperDialog.OnClickNegativeListener getOnNegativeListener() {
                    return listener;
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }

                @Override
                public int getTextColor() {
                    return textColor != 0 ? textColor : -16745729;
                }

                @Override
                public int getHeight() {
                    return height > 0 ? height : super.getHeight();
                }
            });
        }

        public void setPositiveButton(final String text, final int textColor, final int textSize, final int height, final SuperDialog.OnClickPositiveListener listener) {
            this.setProviderFooterPositive(new ProviderFooterPositive(){

                @Override
                public String getTitle() {
                    return text;
                }

                @Override
                public void dismiss() {
                    if (Params.this.mDialogFragment != null) {
                        Params.this.mDialogFragment.dismiss();
                    }
                }

                @Override
                public SuperDialog.OnClickPositiveListener getOnPositiveListener() {
                    return listener;
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }

                @Override
                public int getTextColor() {
                    return textColor != 0 ? textColor : super.getTextColor();
                }

                @Override
                public int getHeight() {
                    return height > 0 ? height : super.getHeight();
                }
            });
        }

        public void setPositiveInputButton(final String text, final int textColor, final int textSize, final int height, final SuperDialog.OnClickPositiveInputListener listener) {
            this.setProviderFooterPositive(new ProviderFooterPositiveInput(){

                @Override
                public String getTitle() {
                    return text;
                }

                @Override
                public void dismiss() {
                    if (Params.this.mDialogFragment != null) {
                        Params.this.mDialogFragment.dismiss();
                    }
                }

                @Override
                public SuperDialog.OnClickPositiveInputListener getOnPositiveInputListener() {
                    return listener;
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }

                @Override
                public int getTextColor() {
                    return textColor != 0 ? textColor : super.getTextColor();
                }

                @Override
                public int getHeight() {
                    return height > 0 ? height : super.getHeight();
                }
            });
        }
    }
}

