/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.mylhyl.superdialog.callback.ProviderContentInput;
import com.mylhyl.superdialog.res.drawable.BgBtn;
import com.mylhyl.superdialog.view.AutoLinearLayout;
import com.mylhyl.superdialog.view.Controller;
import com.mylhyl.superdialog.view.SuperEditText;

class BodyInputView
extends AutoLinearLayout {
    private SuperEditText mEditText;
    private Controller.Params mParams;

    public BodyInputView(Context context, Controller.Params params) {
        super(context);
        this.mParams = params;
        this.initData();
    }

    private void initData() {
        int radius;
        if (this.mParams.mProviderHeader != null && this.mParams.mFooterNegative == null && this.mParams.mFooterPositive == null) {
            radius = this.mParams.mRadius;
            this.setBackgroundDrawable((Drawable)new BgBtn(0, 0, radius, radius, this.mParams.mBackgroundColor));
        } else if (this.mParams.mProviderHeader == null && (this.mParams.mFooterNegative != null || this.mParams.mFooterPositive != null)) {
            radius = this.mParams.mRadius;
            this.setBackgroundDrawable((Drawable)new BgBtn(radius, radius, 0, 0, this.mParams.mBackgroundColor));
        } else if (this.mParams.mFooterNegative == null && this.mParams.mFooterPositive == null && this.mParams.mProviderHeader == null) {
            radius = this.mParams.mRadius;
            this.setBackgroundDrawable((Drawable)new BgBtn(radius, radius, radius, radius, this.mParams.mBackgroundColor));
        } else {
            this.setBackgroundColor(this.mParams.mBackgroundColor);
        }
        ProviderContentInput providerContent = (ProviderContentInput)this.mParams.mProviderContent;
        if (providerContent == null) {
            return;
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        int[] margins = providerContent.getMargins();
        params.setMargins(margins[0], margins[1], margins[2], margins[3]);
        this.mEditText = new SuperEditText(this.getContext());
        this.mEditText.setHint(providerContent.getItems());
        this.mEditText.setHintTextColor(providerContent.getHintTextColor());
        this.mEditText.setTextSize(providerContent.getTextSize());
        this.mEditText.setTextColor(providerContent.getTextColor());
        this.mEditText.setHeight(providerContent.getInputHeight());
        this.addView((View)this.mEditText, (ViewGroup.LayoutParams)params);
    }

    public String getInputText() {
        return this.mEditText.getText().toString();
    }
}

