/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog.auto;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.mylhyl.superdialog.auto.AutoLayoutConfig;

public class AutoUtils {
    public static int scaleValue(int val) {
        return (int)((float)val * AutoLayoutConfig.getInstance().getScale());
    }

    public static int[] getRealScreenSize(Context context) {
        int[] size = new int[2];
        WindowManager w = (WindowManager)context.getSystemService("window");
        Display d = w.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        d.getMetrics(metrics);
        int widthPixels = metrics.widthPixels;
        int heightPixels = metrics.heightPixels;
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
            try {
                widthPixels = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)d, new Object[0]);
                heightPixels = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)d, new Object[0]);
            }
            catch (Exception exception) {}
        } else if (Build.VERSION.SDK_INT >= 17) {
            Point realSize = new Point();
            d.getRealSize(realSize);
            widthPixels = realSize.x;
            heightPixels = realSize.y;
        }
        size[0] = widthPixels;
        size[1] = heightPixels;
        return size;
    }

    public static double getDevicePhysicalSize(Context context) {
        int[] size = AutoUtils.getRealScreenSize(context);
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        double x = Math.pow((float)size[0] / dm.xdpi, 2.0);
        double y = Math.pow((float)size[1] / dm.ydpi, 2.0);
        return Math.sqrt(x + y);
    }
}

