/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog;

import android.app.Dialog;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import com.mylhyl.superdialog.BaseDialog;
import com.mylhyl.superdialog.view.Controller;

public final class SuperDialog
extends BaseDialog {
    private Controller mController;

    private void setController(Builder builder) {
        this.mController = new Controller(builder.mParams);
        this.mController.apply();
        this.mParams = builder.mParams;
    }

    private void refreshProviderContent(Animation animation) {
        this.mController.refreshProviderContent(animation);
    }

    @Override
    public View createView() {
        if (this.mController == null) {
            return null;
        }
        return this.mController.createView();
    }

    public static class Builder
    extends BaseDialog.Builder<Builder> {
        private SuperDialog dialog = new SuperDialog();

        public Builder(FragmentActivity activity) {
            super(activity);
        }

        public Builder setTitle(@NonNull String title) {
            return this.setTitle(title, 0);
        }

        public Builder setTitle(@NonNull String title, @ColorInt int textColor) {
            return this.setTitle(title, textColor, -1);
        }

        public Builder setTitle(@NonNull String title, @ColorInt int textColor, int textSize) {
            return this.setTitle(title, textColor, textSize, -1);
        }

        public Builder setTitle(@NonNull String title, @ColorInt int textColor, int textSize, int height) {
            this.mParams.setTitle(title, textColor, textSize, height);
            return this;
        }

        public Builder setMessage(@NonNull String text) {
            return this.setMessage(text, 0);
        }

        public Builder setMessage(@NonNull String text, @ColorInt int textColor) {
            return this.setMessage(text, textColor, -1);
        }

        public Builder setMessage(@NonNull String text, @ColorInt int textColor, int textSize) {
            return this.setMessage(text, textColor, textSize, null);
        }

        public Builder setMessage(@NonNull String text, @ColorInt int textColor, int textSize, int[] padding) {
            this.mParams.setContentSingle(text, textColor, textSize, padding);
            return this;
        }

        public Builder setItems(@NonNull Object items, OnItemClickListener listener) {
            return this.setItems(items, -1, listener);
        }

        public Builder setItems(@NonNull Object items, int textSize, OnItemClickListener listener) {
            return this.setItems(items, 0, textSize, listener);
        }

        public Builder setItems(@NonNull Object items, @ColorInt int textColor, int textSize, OnItemClickListener listener) {
            return this.setItems(items, textColor, textSize, -1, listener);
        }

        public Builder setItems(@NonNull Object items, @ColorInt int textColor, int textSize, int itemHeight, OnItemClickListener listener) {
            this.setGravity(80);
            this.mParams.setContentMultiple(items, textColor, textSize, itemHeight, listener);
            return this;
        }

        public Builder setInput(@NonNull String hint) {
            return this.setInput(hint, 0);
        }

        public Builder setInput(@NonNull String hint, int textSize) {
            return this.setInput(hint, 0, textSize);
        }

        public Builder setInput(@NonNull String hint, @ColorInt int textColor, int textSize) {
            return this.setInput(hint, textColor, textSize, -1, null);
        }

        public Builder setInput(@NonNull String hint, @ColorInt int textColor, int textSize, int inputHeight, int[] margins) {
            this.mParams.setContentInput(hint, textColor, textSize, inputHeight, margins);
            return this;
        }

        public Builder setNegativeButton(String text, OnClickNegativeListener listener) {
            return this.setNegativeButton(text, 0, listener);
        }

        public Builder setNegativeButton(String text, int textColor, OnClickNegativeListener listener) {
            return this.setNegativeButton(text, textColor, -1, -1, listener);
        }

        public Builder setNegativeButton(String text, int textColor, int textSize, int height, OnClickNegativeListener listener) {
            this.mParams.setNegativeButton(text, textColor, textSize, height, listener);
            return this;
        }

        public Builder setPositiveButton(String text, OnClickPositiveListener listener) {
            return this.setPositiveButton(text, 0, listener);
        }

        public Builder setPositiveButton(String text, int textColor, OnClickPositiveListener listener) {
            return this.setPositiveButton(text, textColor, -1, -1, listener);
        }

        public Builder setPositiveButton(String text, int textColor, int textSize, int height, OnClickPositiveListener listener) {
            this.mParams.setPositiveButton(text, textColor, textSize, height, listener);
            return this;
        }

        public Builder setPositiveButton(String text, OnClickPositiveInputListener listener) {
            return this.setPositiveButton(text, 0, listener);
        }

        public Builder setPositiveButton(String text, int textColor, OnClickPositiveInputListener listener) {
            return this.setPositiveButton(text, textColor, -1, -1, listener);
        }

        public Builder setPositiveButton(String text, int textColor, int textSize, int height, OnClickPositiveInputListener listener) {
            this.mParams.setPositiveButton(text, textColor, textSize, height, listener);
            return this;
        }

        public DialogFragment build() {
            this.checkBuilderParams();
            this.dialog.setController(this);
            this.show();
            return this.dialog;
        }

        public void refreshContent() {
            this.dialog.refreshProviderContent(null);
        }

        public void refreshContent(Animation animation) {
            this.dialog.refreshProviderContent(animation);
        }

        public void show() {
            this.dialog.show(this.mParams.mActivity.getSupportFragmentManager(), "superDialog");
        }
    }

    public static interface ConfigDialog {
        public void onConfig(Dialog var1, Window var2, WindowManager.LayoutParams var3, DisplayMetrics var4);
    }

    public static interface OnClickPositiveInputListener {
        public void onClick(String var1, View var2);
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);
    }

    public static interface OnClickPositiveListener {
        public void onClick(View var1);
    }

    public static interface OnClickNegativeListener {
        public void onClick(View var1);
    }
}

