/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog;

import android.app.Dialog;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.mylhyl.superdialog.BaseDialog;
import com.mylhyl.superdialog.view.Controller;
import java.io.Serializable;

public final class SuperDialog
extends BaseDialog {
    private static final String SAVED_BUILDER = "super.dialog:Builder";
    private Controller mController;
    private Builder mBuilder;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mBuilder = (Builder)savedInstanceState.getSerializable(SAVED_BUILDER);
            this.setController(this.mBuilder);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mController != null) {
            outState.putSerializable(SAVED_BUILDER, (Serializable)this.mBuilder);
        }
    }

    private void setController(Builder builder) {
        this.mBuilder = builder;
        this.mController = new Controller(builder.getContext(), builder.mParams);
        this.mController.apply();
        this.mParams = builder.mParams;
    }

    @Override
    public View createView() {
        if (this.mController == null) {
            return null;
        }
        return this.mController.createView();
    }

    public static class Builder
    extends BaseDialog.Builder<Builder> {
        public Builder(FragmentActivity activity) {
            super(activity);
        }

        public Builder setTitle(String title) {
            return this.setTitle(title, -1);
        }

        public Builder setTitle(String title, int textSize) {
            return this.setTitle(title, textSize, -1);
        }

        public Builder setTitle(String title, int textSize, int height) {
            this.mParams.setTitle(title, textSize, height);
            return this;
        }

        public Builder setMessage(String text) {
            return this.setMessage(text, 0);
        }

        public Builder setMessage(String text, int textColor) {
            return this.setMessage(text, textColor, -1);
        }

        public Builder setMessage(String text, int textColor, int textSize) {
            return this.setMessage(text, textColor, textSize, null);
        }

        public Builder setMessage(String text, int textColor, int textSize, int[] padding) {
            this.mParams.setMessage(text, textColor, textSize, padding);
            return this;
        }

        public Builder setItems(Object items, OnItemClickListener listener) {
            return this.setItems(items, 0, listener);
        }

        public Builder setItems(Object items, int textSize, OnItemClickListener listener) {
            return this.setItems(items, 0, textSize, listener);
        }

        public Builder setItems(Object items, int textColor, int textSize, OnItemClickListener listener) {
            return this.setItems(items, textColor, textSize, -1, listener);
        }

        public Builder setItems(Object items, int textColor, int textSize, int itemHeight, OnItemClickListener listener) {
            this.setGravity(80);
            this.mParams.setMessage(items, textColor, textSize, itemHeight, listener);
            return this;
        }

        public Builder setNegativeButton(String text, OnClickNegativeListener listener) {
            return this.setNegativeButton(text, 0, listener);
        }

        public Builder setNegativeButton(String text, int textColor, OnClickNegativeListener listener) {
            return this.setNegativeButton(text, textColor, -1, -1, listener);
        }

        public Builder setNegativeButton(String text, int textColor, int textSize, int height, OnClickNegativeListener listener) {
            this.mParams.setNegativeButton(text, textColor, textSize, height, listener);
            return this;
        }

        public Builder setPositiveButton(String text, OnClickPositiveListener listener) {
            return this.setPositiveButton(text, 0, listener);
        }

        public Builder setPositiveButton(String text, int textColor, OnClickPositiveListener listener) {
            return this.setPositiveButton(text, textColor, -1, -1, listener);
        }

        public Builder setPositiveButton(String text, int textColor, int textSize, int height, OnClickPositiveListener listener) {
            this.mParams.setPositiveButton(text, textColor, textSize, height, listener);
            return this;
        }

        public DialogFragment build() {
            this.checkBuilderParams();
            SuperDialog dialog = new SuperDialog();
            dialog.setController(this);
            dialog.show(this.mActivity.getSupportFragmentManager(), "superDialog");
            return dialog;
        }
    }

    public static interface ConfigDialog {
        public void onConfig(Dialog var1, Window var2, WindowManager.LayoutParams var3, DisplayMetrics var4);
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);
    }

    public static interface OnClickPositiveListener {
        public void onClick(View var1);
    }

    public static interface OnClickNegativeListener {
        public void onClick(View var1);
    }
}

