/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AlertDialog;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.mylhyl.superdialog.view.Controller;

abstract class BaseDialog
extends DialogFragment {
    private Controller.Params mParams;

    public abstract View createView();

    protected BaseDialog(Controller.Params params) {
        this.mParams = params;
    }

    public final Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        View view = this.createView();
        builder.setView(view);
        AlertDialog dialog = builder.create();
        this.mParams.mDialogFragment = this;
        dialog.setCanceledOnTouchOutside(this.mParams.mCancelable);
        return dialog;
    }

    public void onStart() {
        super.onStart();
        Dialog dialog = this.getDialog();
        if (dialog != null) {
            this.setDialogGravity(dialog);
        }
    }

    private void setDialogGravity(Dialog dialog) {
        Window window = dialog.getWindow();
        window.setBackgroundDrawableResource(17170445);
        WindowManager.LayoutParams wlp = window.getAttributes();
        DisplayMetrics dm = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
        wlp.width = (int)((float)dm.widthPixels * this.mParams.mWidth);
        wlp.gravity = this.mParams.mGravity;
        if (wlp.gravity == 80) {
            wlp.y = 20;
        }
        window.setAttributes(wlp);
    }

    public void show(FragmentManager manager, String tag) {
        FragmentTransaction transaction = manager.beginTransaction();
        transaction.setTransition(4097);
        transaction.add((Fragment)this, tag);
        transaction.commitAllowingStateLoss();
    }

    public static class Builder<T extends Builder> {
        protected FragmentActivity mActivity;
        protected Controller.Params mParams;

        Builder(FragmentActivity activity) {
            this.mActivity = activity;
            this.mParams = new Controller.Params();
        }

        public Context getContext() {
            return this.mActivity;
        }

        public T setGravity(int gravity) {
            this.mParams.mGravity = gravity;
            return (T)this;
        }

        public T setAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
            this.mParams.mAlpha = alpha;
            return (T)this;
        }

        public T setBackgroundColor(@ColorInt int color) {
            this.mParams.mBackgroundColor = color;
            return (T)this;
        }

        public T setRadius(int radius) {
            this.mParams.mRadius = radius;
            return (T)this;
        }

        public T setCanceledOnTouchOutside(boolean cancel) {
            this.mParams.mCancelable = cancel;
            return (T)this;
        }

        public T setWidth(@FloatRange(from=0.0, to=1.0) float width) {
            this.mParams.mWidth = width;
            return (T)this;
        }

        void checkBuilderParams() {
            if (this.mParams.mProviderContent == null) {
                throw new IllegalArgumentException("message is empty, please set");
            }
            if (this.mParams.mProviderContent == null) {
                throw new IllegalArgumentException("alpha is 0.0 to 1.0, please setAlpha");
            }
            if (this.mParams.mWidth < 0.0f || this.mParams.mWidth > 1.0f) {
                throw new IllegalArgumentException("width is 0.0 to 1.0, please setWidth");
            }
        }
    }
}

