/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog.view;

import android.content.Context;
import android.support.v4.app.DialogFragment;
import android.view.View;
import android.view.animation.Animation;
import com.mylhyl.superdialog.SuperDialog;
import com.mylhyl.superdialog.callback.CreateLayout;
import com.mylhyl.superdialog.callback.ProviderContent;
import com.mylhyl.superdialog.callback.ProviderFooterNegative;
import com.mylhyl.superdialog.callback.ProviderFooterPositive;
import com.mylhyl.superdialog.callback.ProviderHeader;
import com.mylhyl.superdialog.view.BodyMultipleView;
import com.mylhyl.superdialog.view.BodySingleView;
import com.mylhyl.superdialog.view.CreateLayoutImpl;
import java.io.Serializable;

public final class Controller {
    private Context mContext;
    private Params mParams;
    private CreateLayout createLayout;

    public Controller(Context context, Params params) {
        this.mContext = context;
        this.mParams = params;
    }

    public void apply() {
        ProviderContent providerContent;
        this.createLayout = new CreateLayoutImpl(this.mContext, this.mParams);
        if (this.mParams.mProviderHeader != null) {
            this.createLayout.buildHead();
        }
        if ((providerContent = this.mParams.mProviderContent) != null && providerContent.getMode() == ProviderContent.Mode.MULTIPLE) {
            this.createLayout.buildMultipleBody();
            if (this.mParams.mFooterNegative != null || this.mParams.mFooterPositive != null) {
                this.createLayout.buildMultipleFooter();
            }
        } else {
            this.createLayout.buildSingleBody();
            if (this.mParams.mFooterNegative != null || this.mParams.mFooterPositive != null) {
                this.createLayout.buildSingleFooter();
            }
        }
    }

    public View createView() {
        return this.createLayout.buildView();
    }

    public void refreshProviderContent(Animation animation) {
        ProviderContent providerContent = this.mParams.mProviderContent;
        if (providerContent != null && providerContent.getMode() == ProviderContent.Mode.MULTIPLE) {
            BodyMultipleView multipleBody = (BodyMultipleView)this.createLayout.findMultipleBody();
            if (multipleBody != null) {
                multipleBody.refreshItems();
            }
        } else {
            BodySingleView singleBody = (BodySingleView)this.createLayout.findSingleBody();
            if (singleBody != null) {
                singleBody.refreshText();
            }
        }
        if (animation != null) {
            this.createView().startAnimation(animation);
        }
    }

    public static class Params
    implements Serializable {
        public DialogFragment mDialogFragment;
        public ProviderHeader mProviderHeader;
        public ProviderContent mProviderContent;
        public ProviderFooterNegative mFooterNegative;
        public ProviderFooterPositive mFooterPositive;
        public int mGravity = 17;
        public boolean mCanceledOnTouchOutside = true;
        public boolean mCancelable = true;
        public int mRadius = 30;
        public float mAlpha = 1.0f;
        public int mBackgroundColor = -460552;
        public float mWidth = 0.9f;
        public int[] mPadding;
        public int mItemsBottomMargin = 10;
        public int mAnimStyle;
        public int x;
        public int y;
        public boolean isDimEnabled = true;
        public SuperDialog.ConfigDialog mConfigDialog;

        public void setTitle(ProviderHeader providerHeader) {
            this.mProviderHeader = providerHeader;
        }

        public void setMessage(ProviderContent providerContent) {
            this.mProviderContent = providerContent;
        }

        public void setNegativeButton(ProviderFooterNegative footerNegative) {
            this.mFooterNegative = footerNegative;
        }

        public void setPositiveButton(ProviderFooterPositive footerPositive) {
            this.mFooterPositive = footerPositive;
        }

        public void setTitle(final String title, final int textSize, final int height) {
            this.setTitle(new ProviderHeader(){

                @Override
                public String getTitle() {
                    return title;
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }

                @Override
                public int getHeight() {
                    return height > 0 ? height : super.getHeight();
                }
            });
        }

        public void setMessage(String text, int textColor, int textSize, int[] padding) {
            this.setMessage(text, textColor, textSize, -1, padding, null);
        }

        public void setMessage(Object items, int textColor, int textSize, int itemHeight, SuperDialog.OnItemClickListener listener) {
            this.setMessage(items, textColor, textSize, itemHeight, null, listener);
        }

        private void setMessage(final Object items, final int textColor, final int textSize, final int itemHeight, final int[] padding, final SuperDialog.OnItemClickListener listener) {
            this.setMessage(new ProviderContent(){

                @Override
                public void dismiss() {
                    if (Params.this.mDialogFragment != null) {
                        Params.this.mDialogFragment.dismiss();
                    }
                }

                @Override
                public Object getItems() {
                    return items;
                }

                @Override
                public ProviderContent.Mode getMode() {
                    return items instanceof String ? ProviderContent.Mode.SINGLE : ProviderContent.Mode.MULTIPLE;
                }

                @Override
                public int getTextColor() {
                    return textColor != 0 ? textColor : super.getTextColor();
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }

                @Override
                public int getItemHeight() {
                    return itemHeight > 0 ? itemHeight : super.getItemHeight();
                }

                @Override
                public int[] getPadding() {
                    return padding != null ? padding : super.getPadding();
                }

                @Override
                public SuperDialog.OnItemClickListener getItemClickListener() {
                    return listener;
                }
            });
        }

        public void setNegativeButton(final String text, final int textColor, final int textSize, final int height, final SuperDialog.OnClickNegativeListener listener) {
            this.setNegativeButton(new ProviderFooterNegative(){

                @Override
                public String getTitle() {
                    return text;
                }

                @Override
                public void dismiss() {
                    if (Params.this.mDialogFragment != null) {
                        Params.this.mDialogFragment.dismiss();
                    }
                }

                @Override
                public SuperDialog.OnClickNegativeListener getOnNegativeListener() {
                    return listener;
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }

                @Override
                public int getTextColor() {
                    return textColor != 0 ? textColor : super.getTextColor();
                }

                @Override
                public int getHeight() {
                    return height > 0 ? height : super.getHeight();
                }
            });
        }

        public void setPositiveButton(final String text, final int textColor, final int textSize, final int height, final SuperDialog.OnClickPositiveListener listener) {
            this.setPositiveButton(new ProviderFooterPositive(){

                @Override
                public String getTitle() {
                    return text;
                }

                @Override
                public void dismiss() {
                    if (Params.this.mDialogFragment != null) {
                        Params.this.mDialogFragment.dismiss();
                    }
                }

                @Override
                public SuperDialog.OnClickPositiveListener getOnPositiveListener() {
                    return listener;
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }

                @Override
                public int getTextColor() {
                    return textColor != 0 ? textColor : super.getTextColor();
                }

                @Override
                public int getHeight() {
                    return height > 0 ? height : super.getHeight();
                }
            });
        }
    }
}

