/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.LinearLayout;
import com.mylhyl.superdialog.SuperDialog;
import com.mylhyl.superdialog.auto.AutoUtils;
import com.mylhyl.superdialog.callback.CreateLayout;
import com.mylhyl.superdialog.callback.ProviderFooterNegative;
import com.mylhyl.superdialog.res.drawable.BgBtn;
import com.mylhyl.superdialog.view.AutoLinearLayout;
import com.mylhyl.superdialog.view.BodyMultipleView;
import com.mylhyl.superdialog.view.BodySingleView;
import com.mylhyl.superdialog.view.Controller;
import com.mylhyl.superdialog.view.DividerView;
import com.mylhyl.superdialog.view.FooterView;
import com.mylhyl.superdialog.view.HeaderView;
import com.mylhyl.superdialog.view.SuperTextView;

class CreateLayoutImpl
implements CreateLayout {
    private Context mContext;
    private Controller.Params mParams;
    private LinearLayout mRoot;

    public CreateLayoutImpl(Context context, Controller.Params params) {
        this.mContext = context;
        this.mParams = params;
        this.mRoot = new AutoLinearLayout(context);
        this.mRoot.setOrientation(1);
        this.mRoot.setAlpha(params.mAlpha);
    }

    @Override
    public void buildHead() {
        HeaderView titleView = new HeaderView(this.mContext, this.mParams);
        this.mRoot.addView((View)titleView);
    }

    @Override
    public void buildMultipleBody() {
        this.mRoot.addView((View)new BodyMultipleView(this.mContext, this.mParams), (ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
    }

    @Override
    public void buildSingleBody() {
        this.mRoot.addView((View)new BodySingleView(this.mContext, this.mParams));
    }

    @Override
    public void buildMultipleFooter() {
        final ProviderFooterNegative footerNegative = this.mParams.mFooterNegative;
        final SuperDialog.OnClickNegativeListener onNegativeListener = footerNegative.getOnNegativeListener();
        SuperTextView footerView = new SuperTextView(this.mContext);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2, 1.0f);
        layoutParams.topMargin = AutoUtils.scaleValue(this.mParams.mItemsBottomMargin);
        footerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        footerView.setClickable(true);
        footerView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                footerNegative.dismiss();
                if (onNegativeListener != null) {
                    onNegativeListener.onClick(v);
                }
            }
        });
        footerView.setText(footerNegative.getTitle());
        footerView.setTextSize(footerNegative.getTextSize());
        footerView.setTextColor(footerNegative.getTextColor());
        footerView.setHeight(footerNegative.getHeight());
        int radius = this.mParams.mRadius;
        footerView.setBackgroundDrawable((Drawable)new BgBtn(radius, radius, radius, radius, this.mParams.mBackgroundColor));
        this.mRoot.addView((View)footerView);
    }

    @Override
    public void buildSingleFooter() {
        DividerView dividerViewV = new DividerView(this.mContext);
        dividerViewV.setVertical();
        this.mRoot.addView((View)dividerViewV);
        this.mRoot.addView((View)new FooterView(this.mContext, this.mParams));
    }

    @Override
    public View buildView() {
        return this.mRoot;
    }
}

