/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog.auto;

import android.content.Context;
import com.mylhyl.superdialog.auto.AutoScaleAdapter;
import com.mylhyl.superdialog.auto.AutoUtils;

public class AutoLayoutConfig {
    private static AutoLayoutConfig sInstance;
    private static final String KEY_DESIGN_WIDTH = "design_width";
    private static final String KEY_DESIGN_HEIGHT = "design_height";
    private int mScreenWidth;
    private int mScreenHeight;
    private int mDesignWidth = 1080;
    private int mDesignHeight = 1920;
    private float mScale;

    private AutoLayoutConfig() {
    }

    public static void init(Context context) {
        if (sInstance == null) {
            sInstance = new AutoLayoutConfig();
            sInstance.initInternal(context, new AutoScaleAdapter(context));
        }
    }

    public static AutoLayoutConfig getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("Must init before using.");
        }
        return sInstance;
    }

    private void initInternal(Context context, AutoScaleAdapter scaleAdapter) {
        float designScale;
        float deviceScale;
        this.checkParams();
        int[] size = AutoUtils.getRealScreenSize(context);
        this.mScreenWidth = size[0];
        this.mScreenHeight = size[1];
        if (this.mScreenWidth > this.mScreenHeight) {
            this.mScreenWidth += this.mScreenHeight;
            this.mScreenHeight = this.mScreenWidth - this.mScreenHeight;
            this.mScreenWidth -= this.mScreenHeight;
        }
        this.mScale = (deviceScale = (float)this.mScreenHeight / (float)this.mScreenWidth) <= (designScale = (float)this.mDesignHeight / (float)this.mDesignWidth) ? (float)this.mScreenHeight / (float)this.mDesignHeight : (float)this.mScreenWidth / (float)this.mDesignWidth;
        if (scaleAdapter != null) {
            this.mScale = scaleAdapter.adapt(this.mScale, this.mScreenWidth, this.mScreenHeight);
        }
    }

    private void checkParams() {
        if (this.mDesignHeight <= 0 || this.mDesignWidth <= 0) {
            throw new RuntimeException("you must set design_width and design_height  in your manifest file.");
        }
    }

    public int getScreenWidth() {
        return this.mScreenWidth;
    }

    public int getScreenHeight() {
        return this.mScreenHeight;
    }

    public int getDesignWidth() {
        return this.mDesignWidth;
    }

    public int getDesignHeight() {
        return this.mDesignHeight;
    }

    public float getScale() {
        return this.mScale;
    }
}

