/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.mylhyl.superdialog.SuperDialog;
import com.mylhyl.superdialog.callback.ProviderContent;
import com.mylhyl.superdialog.callback.ProviderHeader;
import com.mylhyl.superdialog.res.drawable.BgBtn;
import com.mylhyl.superdialog.view.SuperTextView;
import java.util.Arrays;
import java.util.List;

class ContentMultipleView
extends ListView {
    public ContentMultipleView(Context context, SuperDialog.Builder builder) {
        super(context);
        this.initData(builder);
    }

    private void initData(SuperDialog.Builder builder) {
        this.setAlpha(builder.mAlpha);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.setSelector((Drawable)new ColorDrawable(0));
        final ProviderContent providerContent = builder.getProviderContent();
        if (providerContent == null) {
            return;
        }
        this.setDivider((Drawable)new ColorDrawable(-2631717));
        this.setDividerHeight(1);
        this.setAdapter((ListAdapter)new ItemAdapter(builder));
        this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                providerContent.dismiss();
                if (providerContent.getItemClickListener() != null) {
                    providerContent.getItemClickListener().onItemClick(position);
                }
            }
        });
    }

    class ItemAdapter<T>
    extends BaseAdapter {
        private List<T> mItems;
        private int Radius;
        private ProviderContent mProviderContent;
        private ProviderHeader mProviderHeader;

        public ItemAdapter(SuperDialog.Builder builder) {
            this.Radius = builder.mRadius;
            this.mProviderContent = builder.getProviderContent();
            this.mProviderHeader = builder.getProviderHeader();
            Object entity = this.mProviderContent.getItems();
            if (entity instanceof Iterable) {
                this.mItems = (List)entity;
            } else if (entity.getClass().isArray()) {
                this.mItems = Arrays.asList((Object[])entity);
            } else {
                throw new IllegalArgumentException("entity must be an Array or an Iterable.");
            }
        }

        public int getCount() {
            if (this.mItems != null) {
                return this.mItems.size();
            }
            return 0;
        }

        public T getItem(int position) {
            if (this.mItems != null) {
                return this.mItems.get(position);
            }
            return null;
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder;
            if (convertView == null) {
                viewHolder = new ViewHolder();
                SuperTextView textView = new SuperTextView(ContentMultipleView.this.getContext());
                textView.setTextSize(this.mProviderContent.getTextSize());
                textView.setTextColor(this.mProviderContent.getTextColor());
                textView.setHeight(this.mProviderContent.getItemHeight());
                viewHolder.item = textView;
                convertView = textView;
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            if (position == 0 && this.mProviderHeader == null) {
                viewHolder.item.setBackgroundDrawable((Drawable)new BgBtn(this.Radius, this.Radius, 0, 0));
            } else if (position == this.getCount() - 1) {
                viewHolder.item.setBackgroundDrawable((Drawable)new BgBtn(0, 0, this.Radius, this.Radius));
            } else {
                viewHolder.item.setBackgroundDrawable((Drawable)new BgBtn(0, 0, 0, 0));
            }
            viewHolder.item.setText((CharSequence)String.valueOf(this.getItem(position).toString()));
            return convertView;
        }

        class ViewHolder {
            TextView item;

            ViewHolder() {
            }
        }
    }
}

