/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog;

import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.mylhyl.superdialog.BaseDialog;
import com.mylhyl.superdialog.ItemsLayout;
import com.mylhyl.superdialog.MessageLayout;
import com.mylhyl.superdialog.callback.ProviderContent;
import com.mylhyl.superdialog.callback.ProviderFooterNegative;
import com.mylhyl.superdialog.callback.ProviderFooterPositive;
import com.mylhyl.superdialog.callback.ProviderHeader;

public final class SuperDialog
extends BaseDialog {
    private Builder mBuilder;

    private SuperDialog(Builder builder) {
        super(builder);
        this.mBuilder = builder;
    }

    @Override
    public View createView() {
        ProviderContent providerContent = this.mBuilder.getProviderContent();
        if (providerContent != null && providerContent.getMode() == ProviderContent.Mode.MULTIPLE) {
            return new ItemsLayout(this.getContext(), this.mBuilder);
        }
        return new MessageLayout(this.getContext(), this.mBuilder);
    }

    public static class Builder
    extends BaseDialog.Builder<Builder> {
        private ProviderHeader mProviderHeader;
        private ProviderContent mProviderContent;
        private ProviderFooterNegative mFooterNegative;
        private ProviderFooterPositive mFooterPositive;

        public Builder(FragmentActivity activity) {
            super(activity);
        }

        public Builder setTitle(String title) {
            return this.setTitle(title, -1);
        }

        public Builder setTitle(String title, int textSize) {
            return this.setTitle(title, textSize, -1);
        }

        public Builder setTitle(final String title, final int textSize, final int height) {
            return this.setTitle(new ProviderHeader(){

                @Override
                public String getTitle() {
                    return title;
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }

                @Override
                public int getHeight() {
                    return height > 0 ? height : super.getHeight();
                }
            });
        }

        public Builder setMessage(String text) {
            this.setMessage(text, -1);
            return this;
        }

        public Builder setMessage(String text, int textColor) {
            this.setMessage(text, textColor, -1);
            return this;
        }

        public Builder setMessage(String text, int textColor, int textSize) {
            this.setMessage(text, textColor, textSize, null);
            return this;
        }

        public Builder setMessage(final String text, final int textColor, final int textSize, final int[] padding) {
            return this.setMessage(new ProviderContent(){

                @Override
                public String getText() {
                    return text;
                }

                @Override
                public ProviderContent.Mode getMode() {
                    return ProviderContent.Mode.SINGLE;
                }

                @Override
                public int getTextColor() {
                    return textColor > 0 ? textColor : super.getTextColor();
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }

                @Override
                public int[] getPadding() {
                    return padding != null ? padding : super.getPadding();
                }
            });
        }

        public Builder setItems(String[] items, OnItemClickListener listener) {
            return this.setItems(items, -1, listener);
        }

        public Builder setItems(String[] items, int textSize, OnItemClickListener listener) {
            return this.setItems(items, -1, textSize, listener);
        }

        public Builder setItems(String[] items, int textColor, int textSize, OnItemClickListener listener) {
            return this.setItems(items, textColor, textSize, -1, listener);
        }

        public Builder setItems(final String[] items, final int textColor, final int textSize, final int itemHeight, final OnItemClickListener listener) {
            return this.setMessage(new ProviderContent(){

                @Override
                public void dismiss() {
                    if (Builder.this.mDialogFragment != null) {
                        Builder.this.mDialogFragment.dismiss();
                    }
                }

                @Override
                public String[] getItems() {
                    return items;
                }

                @Override
                public ProviderContent.Mode getMode() {
                    return ProviderContent.Mode.MULTIPLE;
                }

                @Override
                public int getTextColor() {
                    return textColor > 0 ? textColor : super.getTextColor();
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }

                @Override
                public int getItemHeight() {
                    return itemHeight > 0 ? itemHeight : super.getItemHeight();
                }

                @Override
                public OnItemClickListener getItemClickListener() {
                    return listener;
                }
            });
        }

        public Builder setNegativeButton(String text, OnClickNegativeListener listener) {
            return this.setNegativeButton(text, -1, listener);
        }

        public Builder setNegativeButton(String text, int textColor, OnClickNegativeListener listener) {
            return this.setNegativeButton(text, textColor, -1, -1, listener);
        }

        public Builder setNegativeButton(final String text, final int textSize, final int textColor, final int height, final OnClickNegativeListener listener) {
            return this.setNegativeButton(new ProviderFooterNegative(){

                @Override
                public String getTitle() {
                    return text;
                }

                @Override
                public void dismiss() {
                    if (Builder.this.mDialogFragment != null) {
                        Builder.this.mDialogFragment.dismiss();
                    }
                }

                @Override
                public OnClickNegativeListener getOnNegativeListener() {
                    return listener;
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }

                @Override
                public int getTextColor() {
                    return textColor > 0 ? textColor : super.getTextColor();
                }

                @Override
                public int getHeight() {
                    return height > 0 ? height : super.getHeight();
                }
            });
        }

        public Builder setPositiveButton(String text, OnClickPositiveListener listener) {
            return this.setPositiveButton(text, -1, listener);
        }

        public Builder setPositiveButton(String text, int textColor, OnClickPositiveListener listener) {
            return this.setPositiveButton(text, textColor, -1, -1, listener);
        }

        public Builder setPositiveButton(final String text, final int textSize, final int textColor, final int height, final OnClickPositiveListener listener) {
            return this.setPositiveButton(new ProviderFooterPositive(){

                @Override
                public String getTitle() {
                    return text;
                }

                @Override
                public void dismiss() {
                    if (Builder.this.mDialogFragment != null) {
                        Builder.this.mDialogFragment.dismiss();
                    }
                }

                @Override
                public OnClickPositiveListener getOnPositiveListener() {
                    return listener;
                }

                @Override
                public int getTextSize() {
                    return textSize > 0 ? textSize : super.getTextSize();
                }

                @Override
                public int getTextColor() {
                    return textColor > 0 ? textColor : super.getTextColor();
                }

                @Override
                public int getHeight() {
                    return height > 0 ? height : super.getHeight();
                }
            });
        }

        public Builder setTitle(ProviderHeader mProviderHeader) {
            this.mProviderHeader = mProviderHeader;
            return this;
        }

        public Builder setMessage(ProviderContent providerContent) {
            this.mProviderContent = providerContent;
            return this;
        }

        public Builder setNegativeButton(ProviderFooterNegative mFooterNegative) {
            this.mFooterNegative = mFooterNegative;
            return this;
        }

        public Builder setPositiveButton(ProviderFooterPositive mFooterPositive) {
            this.mFooterPositive = mFooterPositive;
            return this;
        }

        ProviderHeader getProviderHeader() {
            return this.mProviderHeader;
        }

        ProviderContent getProviderContent() {
            return this.mProviderContent;
        }

        ProviderFooterNegative getFooterNegative() {
            return this.mFooterNegative;
        }

        ProviderFooterPositive getFooterPositive() {
            return this.mFooterPositive;
        }

        public void build() {
            this.checkBuilderParams();
            SuperDialog dialog = new SuperDialog(this);
            dialog.show(this.mActivity.getSupportFragmentManager(), "superDialog");
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);
    }

    public static interface OnClickPositiveListener {
        public void onClick(View var1);
    }

    public static interface OnClickNegativeListener {
        public void onClick(View var1);
    }
}

