/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.LinearLayout;
import com.mylhyl.superdialog.ContentMultipleView;
import com.mylhyl.superdialog.DimenLinearLayout;
import com.mylhyl.superdialog.HeaderView;
import com.mylhyl.superdialog.SuperDialog;
import com.mylhyl.superdialog.callback.ProviderFooterNegative;
import com.mylhyl.superdialog.callback.ProviderHeader;
import com.mylhyl.superdialog.res.drawable.BgBtn;
import com.mylhyl.superdialog.res.drawable.BgLayout;
import com.mylhyl.superdialog.view.SuperTextView;

final class ItemsLayout
extends DimenLinearLayout {
    public ItemsLayout(Context context, SuperDialog.Builder builder) {
        super(context);
        this.init(builder);
    }

    private void init(SuperDialog.Builder builder) {
        this.setOrientation(1);
        ProviderHeader providerHeader = builder.getProviderHeader();
        if (providerHeader != null) {
            HeaderView titleView = new HeaderView(this.getContext(), providerHeader);
            this.addView((View)titleView);
        }
        ContentMultipleView contentView = new ContentMultipleView(this.getContext(), builder);
        this.addView((View)contentView, (ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
        final ProviderFooterNegative footerNegative = builder.getFooterNegative();
        if (footerNegative != null) {
            final SuperDialog.OnClickNegativeListener onNegativeListener = footerNegative.getOnNegativeListener();
            SuperTextView footerView = new SuperTextView(this.getContext());
            footerView.setBackgroundDrawable((Drawable)new BgLayout());
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2, 1.0f);
            layoutParams.topMargin = 10;
            footerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            footerView.setClickable(true);
            footerView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    footerNegative.dismiss();
                    if (onNegativeListener != null) {
                        onNegativeListener.onClick(v);
                    }
                }
            });
            footerView.setText(footerNegative.getTitle());
            footerView.setTextSize(footerNegative.getTextSize());
            footerView.setTextColor(footerNegative.getTextColor());
            footerView.setHeight(footerNegative.getHeight());
            footerView.setBackgroundDrawable((Drawable)new BgBtn(30, 30, 30, 30));
            this.addView((View)footerView);
        }
    }
}

