/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.mylhyl.superdialog.SuperDialog;
import com.mylhyl.superdialog.callback.ProviderFooterNegative;
import com.mylhyl.superdialog.callback.ProviderFooterPositive;
import com.mylhyl.superdialog.res.drawable.BgBtn;
import com.mylhyl.superdialog.view.DividerView;
import com.mylhyl.superdialog.view.SuperTextView;

class FooterView
extends LinearLayout {
    public FooterView(Context context, SuperDialog.Builder builder) {
        super(context);
        this.init(builder);
    }

    private void init(SuperDialog.Builder builder) {
        final ProviderFooterNegative footerNegative = builder.getFooterNegative();
        final ProviderFooterPositive footerPositive = builder.getFooterPositive();
        this.setOrientation(0);
        if (footerNegative != null) {
            final SuperDialog.OnClickNegativeListener onNegativeListener = footerNegative.getOnNegativeListener();
            SuperTextView mNegativeButton = new SuperTextView(this.getContext());
            mNegativeButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
            mNegativeButton.setClickable(true);
            mNegativeButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    footerNegative.dismiss();
                    if (onNegativeListener != null) {
                        onNegativeListener.onClick(v);
                    }
                }
            });
            mNegativeButton.setText(footerNegative.getTitle());
            mNegativeButton.setTextSize(footerNegative.getTextSize());
            mNegativeButton.setTextColor(footerNegative.getTextColor());
            mNegativeButton.setHeight(footerNegative.getHeight());
            if (footerPositive != null) {
                mNegativeButton.setBackgroundDrawable((Drawable)new BgBtn(0, 0, 0, 30));
            } else {
                mNegativeButton.setBackgroundDrawable((Drawable)new BgBtn(0, 0, 30, 30));
            }
            this.addView((View)mNegativeButton);
        }
        if (footerNegative != null && footerPositive != null) {
            DividerView dividerView = new DividerView(this.getContext());
            this.addView(dividerView);
        }
        if (footerPositive != null) {
            final SuperDialog.OnClickPositiveListener onPositiveListener = footerPositive.getOnPositiveListener();
            SuperTextView mPositiveButton = new SuperTextView(this.getContext());
            mPositiveButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
            mPositiveButton.setClickable(true);
            mPositiveButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    footerPositive.dismiss();
                    if (onPositiveListener != null) {
                        onPositiveListener.onClick(v);
                    }
                }
            });
            mPositiveButton.setText(footerPositive.getTitle());
            mPositiveButton.setTextSize(footerPositive.getTextSize());
            mPositiveButton.setTextColor(footerPositive.getTextColor());
            mPositiveButton.setHeight(footerPositive.getHeight());
            if (footerNegative != null) {
                mPositiveButton.setBackgroundDrawable((Drawable)new BgBtn(0, 0, 30, 0));
            } else {
                mPositiveButton.setBackgroundDrawable((Drawable)new BgBtn(0, 0, 30, 30));
            }
            this.addView((View)mPositiveButton);
        }
    }
}

