/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.mylhyl.superdialog.SuperDialog;
import com.mylhyl.superdialog.callback.ProviderContent;
import com.mylhyl.superdialog.callback.ProviderHeader;
import com.mylhyl.superdialog.res.drawable.BgBtn;
import com.mylhyl.superdialog.res.drawable.BgLayout;
import com.mylhyl.superdialog.view.SuperTextView;

class ContentMultipleView
extends ListView {
    public ContentMultipleView(Context context, SuperDialog.Builder builder) {
        super(context);
        this.initData(builder);
    }

    private void initData(SuperDialog.Builder builder) {
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.setSelector((Drawable)new BgLayout());
        final ProviderContent providerContent = builder.getProviderContent();
        if (providerContent == null) {
            return;
        }
        this.setDivider((Drawable)new ColorDrawable(-2631717));
        this.setDividerHeight(1);
        this.setAdapter((ListAdapter)new ItemAdapter(builder));
        this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                providerContent.dismiss();
                if (providerContent.getItemClickListener() != null) {
                    providerContent.getItemClickListener().onItemClick(position);
                }
            }
        });
    }

    class ItemAdapter
    extends BaseAdapter {
        private String[] items;
        private ProviderContent providerContent;
        private ProviderHeader providerHeader;

        public ItemAdapter(SuperDialog.Builder builder) {
            this.providerContent = builder.getProviderContent();
            this.providerHeader = builder.getProviderHeader();
            this.items = this.providerContent.getItems();
        }

        public int getCount() {
            if (this.items != null) {
                return this.items.length;
            }
            return 0;
        }

        public Object getItem(int position) {
            if (this.items != null) {
                return this.items[position];
            }
            return null;
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder;
            if (convertView == null) {
                viewHolder = new ViewHolder();
                SuperTextView textView = new SuperTextView(ContentMultipleView.this.getContext());
                textView.setTextSize(this.providerContent.getTextSize());
                textView.setTextColor(this.providerContent.getTextColor());
                textView.setHeight(this.providerContent.getItemHeight());
                viewHolder.item = textView;
                convertView = textView;
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            if (position == 0 && this.providerHeader == null) {
                viewHolder.item.setBackgroundDrawable((Drawable)new BgBtn(30, 30, 0, 0));
            } else if (position == this.getCount() - 1) {
                viewHolder.item.setBackgroundDrawable((Drawable)new BgBtn(0, 0, 30, 30));
            } else {
                viewHolder.item.setBackgroundDrawable((Drawable)new BgBtn(0, 0, 0, 0));
            }
            viewHolder.item.setText((CharSequence)String.valueOf(this.getItem(position)));
            return convertView;
        }

        class ViewHolder {
            TextView item;

            ViewHolder() {
            }
        }
    }
}

