/*
 * Decompiled with CFR 0.152.
 */
package com.mylhyl.superdialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AlertDialog;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

abstract class BaseDialog
extends DialogFragment {
    private Builder mBuilder;

    public abstract View createView();

    protected BaseDialog(Builder builder) {
        this.mBuilder = builder;
    }

    public final Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        View view = this.createView();
        builder.setView(view);
        AlertDialog dialog = builder.create();
        this.mBuilder.mDialogFragment = this;
        dialog.setCanceledOnTouchOutside(false);
        this.setDialogGravity((Dialog)dialog);
        return dialog;
    }

    private void setDialogGravity(Dialog dialog) {
        Window window = dialog.getWindow();
        window.setBackgroundDrawableResource(17170445);
        WindowManager.LayoutParams wlp = window.getAttributes();
        Display d = window.getWindowManager().getDefaultDisplay();
        wlp.width = (int)((double)d.getWidth() * 0.9);
        wlp.gravity = this.mBuilder.mGravity;
        if (wlp.gravity == 80) {
            wlp.y = 20;
        }
        window.setAttributes(wlp);
    }

    public void show(FragmentManager manager, String tag) {
        FragmentTransaction transaction = manager.beginTransaction();
        transaction.setTransition(4097);
        transaction.add((Fragment)this, tag);
        transaction.commitAllowingStateLoss();
    }

    public static class Builder<T extends Builder> {
        protected FragmentActivity mActivity;
        protected DialogFragment mDialogFragment;
        private int mGravity = 17;

        Builder(FragmentActivity activity) {
            this.mActivity = activity;
        }

        public Context getContext() {
            return this.mActivity;
        }

        public T setGravity(int gravity) {
            this.mGravity = gravity;
            return (T)this;
        }

        void checkBuilderParams() {
        }
    }
}

