/*
 * Decompiled with CFR 0.152.
 */
package com.myhexaville.smartimagepicker;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.widget.Toast;
import com.myhexaville.smartimagepicker.OnImagePickedListener;
import com.myhexaville.smartimagepicker.R;
import com.theartofdev.edmodo.cropper.CropImage;
import com.theartofdev.edmodo.cropper.CropImageView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ImagePicker {
    private static final String LOG_TAG = "PhotoPicker";
    private static final int CAMERA_CAPTURE_PERMISSIONS_REQUEST_CODE_WITH_CAMERA = 100;
    private OnImagePickedListener listener;
    private Activity activity;
    private Fragment fragment;
    private Uri cropImageUri;
    private File imageFile;
    private int aspectRatioX;
    private int aspectRatioY;
    private boolean withCrop;

    public ImagePicker(Activity activity, @Nullable Fragment fragment, OnImagePickedListener listener) {
        this.activity = activity;
        this.fragment = fragment;
        this.listener = listener;
    }

    public ImagePicker setWithImageCrop(int aspectRatioX, int aspectRatioY) {
        this.withCrop = true;
        this.aspectRatioX = aspectRatioX;
        this.aspectRatioY = aspectRatioY;
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public void choosePicture(boolean includeCamera) {
        if (includeCamera) {
            if (CropImage.isExplicitCameraPermissionRequired((Context)this.activity)) {
                if (this.fragment != null) {
                    this.fragment.requestPermissions(new String[]{"android.permission.CAMERA"}, 100);
                } else {
                    this.activity.requestPermissions(new String[]{"android.permission.CAMERA"}, 100);
                }
            } else {
                CropImage.startPickImageActivity((Activity)this.activity);
            }
        } else {
            Intent target;
            ArrayList allIntents = new ArrayList();
            PackageManager packageManager = this.activity.getPackageManager();
            List galleryIntents = CropImage.getGalleryIntents((PackageManager)packageManager, (String)"android.intent.action.GET_CONTENT", (boolean)false);
            if (galleryIntents.size() == 0) {
                galleryIntents = CropImage.getGalleryIntents((PackageManager)packageManager, (String)"android.intent.action.PICK", (boolean)false);
            }
            allIntents.addAll(galleryIntents);
            if (allIntents.isEmpty()) {
                target = new Intent();
            } else {
                target = (Intent)allIntents.get(allIntents.size() - 1);
                allIntents.remove(allIntents.size() - 1);
            }
            Intent chooserIntent = Intent.createChooser((Intent)target, (CharSequence)this.activity.getString(R.string.select_source));
            chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", allIntents.toArray(new Parcelable[allIntents.size()]));
            this.activity.startActivityForResult(chooserIntent, 200);
        }
    }

    @SuppressLint(value={"NewApi"})
    public void openCamera() {
        if (CropImage.isExplicitCameraPermissionRequired((Context)this.activity)) {
            if (this.fragment != null) {
                this.fragment.requestPermissions(new String[]{"android.permission.CAMERA"}, 2011);
            } else {
                this.activity.requestPermissions(new String[]{"android.permission.CAMERA"}, 2011);
            }
        } else {
            Intent target;
            ArrayList allIntents = new ArrayList();
            PackageManager packageManager = this.activity.getPackageManager();
            allIntents.addAll(CropImage.getCameraIntents((Context)this.activity, (PackageManager)packageManager));
            if (allIntents.isEmpty()) {
                target = new Intent();
            } else {
                target = (Intent)allIntents.get(allIntents.size() - 1);
                allIntents.remove(allIntents.size() - 1);
            }
            Intent chooserIntent = Intent.createChooser((Intent)target, (CharSequence)this.activity.getString(R.string.select_source));
            chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", allIntents.toArray(new Parcelable[allIntents.size()]));
            this.activity.startActivityForResult(chooserIntent, 200);
        }
    }

    public void handlePermission(int requestCode, int[] grantResults) {
        Log.d((String)LOG_TAG, (String)("handlePermission: " + requestCode));
        if (requestCode == 100) {
            Log.d((String)LOG_TAG, (String)"handlePermission: 1");
            if (grantResults.length > 0 && grantResults[0] == 0) {
                CropImage.startPickImageActivity((Activity)this.activity);
            } else {
                Toast.makeText((Context)this.activity, (int)R.string.canceling, (int)0).show();
            }
        } else if (requestCode == 2011) {
            Log.d((String)LOG_TAG, (String)"handlePermission: 1");
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.openCamera();
            } else {
                Toast.makeText((Context)this.activity, (int)R.string.canceling, (int)0).show();
            }
        } else if (requestCode == 201) {
            Log.d((String)LOG_TAG, (String)"handlePermission: 2");
            if (this.cropImageUri != null && grantResults.length > 0 && grantResults[0] == 0) {
                if (this.withCrop) {
                    CropImage.activity((Uri)this.cropImageUri).setGuidelines(CropImageView.Guidelines.ON).setAspectRatio(this.aspectRatioX, this.aspectRatioY).start(this.activity);
                } else {
                    this.listener.onImagePicked(this.cropImageUri);
                }
            } else {
                Toast.makeText((Context)this.activity, (int)R.string.canceling, (int)0).show();
            }
        }
    }

    public void handleActivityResult(int resultCode, int requestCode, Intent data) {
        if (resultCode == -1) {
            Log.d((String)LOG_TAG, (String)"handleActivityResult: 1");
            if (requestCode == 200) {
                Log.d((String)LOG_TAG, (String)"handleActivityResult: 2");
                this.handlePickedImageResult(data);
            } else if (requestCode == 203) {
                this.handleCroppedImageResult(data);
            }
        } else {
            Log.d((String)LOG_TAG, (String)("handleActivityResult: " + resultCode));
            if (resultCode == 204) {
                Log.d((String)LOG_TAG, (String)"onActivityResult: Image picker Error");
            }
        }
    }

    public File getImageFile() {
        return this.imageFile;
    }

    private void handleCroppedImageResult(Intent data) {
        Log.d((String)LOG_TAG, (String)"handleCroppedImageResult: ");
        CropImage.ActivityResult result = CropImage.getActivityResult((Intent)data);
        Uri croppedImageUri = result.getUri();
        this.listener.onImagePicked(croppedImageUri);
        this.imageFile = new File(croppedImageUri.getPath());
    }

    @SuppressLint(value={"NewApi"})
    private void handlePickedImageResult(Intent data) {
        Uri imageUri = CropImage.getPickImageResultUri((Context)this.activity, (Intent)data);
        if (CropImage.isReadExternalStoragePermissionsRequired((Context)this.activity, (Uri)imageUri)) {
            Log.d((String)LOG_TAG, (String)"handlePickedImageResult: 1");
            this.cropImageUri = imageUri;
            this.activity.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 201);
        } else {
            Log.d((String)LOG_TAG, (String)("onActivityResult: " + imageUri));
            if (this.withCrop) {
                CropImage.activity((Uri)imageUri).setGuidelines(CropImageView.Guidelines.ON).setAspectRatio(this.aspectRatioX, this.aspectRatioY).start(this.activity);
            } else {
                this.listener.onImagePicked(imageUri);
            }
        }
    }
}

