/*
 * Decompiled with CFR 0.152.
 */
package com.myhexaville.smartimagepicker;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.FileProvider;
import android.util.Log;
import android.widget.Toast;
import com.myhexaville.smartimagepicker.ImagePickerContract;
import com.myhexaville.smartimagepicker.OnImagePickedListener;
import com.myhexaville.smartimagepicker.R;
import com.theartofdev.edmodo.cropper.CropImage;
import com.theartofdev.edmodo.cropper.CropImageView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ImagePicker
implements ImagePickerContract {
    private static final String TAG = "ImagePicker";
    private static final int CAMERA_CAPTURE_PERMISSIONS_REQUEST_CODE_WITH_CAMERA = 100;
    private static final int CAMERA_CAPTURE_PERMISSIONS_REQUEST_CODE_WITHOUT_CAMERA = 101;
    private static String currentCameraFileName = "";
    private OnImagePickedListener listener;
    private Activity activity;
    private Fragment fragment;
    private File imageFile;
    private int aspectRatioX;
    private int aspectRatioY;
    private boolean withCrop;

    public ImagePicker(Activity activity, @Nullable Fragment fragment, OnImagePickedListener listener) {
        this.activity = activity;
        this.fragment = fragment;
        this.listener = listener;
    }

    @Override
    public ImagePicker setWithImageCrop(int aspectRatioX, int aspectRatioY) {
        this.withCrop = true;
        this.aspectRatioX = aspectRatioX;
        this.aspectRatioY = aspectRatioY;
        return this;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void choosePicture(boolean includeCamera) {
        if (this.needToAskPermissions()) {
            int requestCode;
            String[] neededPermissions = this.getNeededPermissions();
            int n = requestCode = includeCamera ? 100 : 101;
            if (this.fragment != null) {
                this.fragment.requestPermissions(neededPermissions, requestCode);
            } else {
                this.activity.requestPermissions(neededPermissions, requestCode);
            }
        } else {
            this.startImagePickerActivity(includeCamera);
        }
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void openCamera() {
        if (this.needToAskPermissions()) {
            if (this.fragment != null) {
                this.fragment.requestPermissions(this.getNeededPermissions(), 2011);
            } else {
                this.activity.requestPermissions(this.getNeededPermissions(), 2011);
            }
        } else {
            Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
            Intent cameraIntent = this.getCameraIntent();
            if (takePictureIntent.resolveActivity(this.activity.getPackageManager()) != null) {
                this.activity.startActivityForResult(cameraIntent, 200);
            }
        }
    }

    @Override
    @NonNull
    public File getImageFile() {
        return this.imageFile;
    }

    @Override
    public void handlePermission(int requestCode, int[] grantResults) {
        Log.d((String)TAG, (String)("handlePermission: " + requestCode));
        if (requestCode == 100) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.startImagePickerActivity(true);
            } else {
                Toast.makeText((Context)this.activity, (int)R.string.canceling, (int)0).show();
            }
        }
        if (requestCode == 101) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.startImagePickerActivity(false);
            } else {
                Toast.makeText((Context)this.activity, (int)R.string.canceling, (int)0).show();
            }
        } else if (requestCode == 2011) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.openCamera();
            } else {
                Toast.makeText((Context)this.activity, (int)R.string.canceling, (int)0).show();
            }
        }
    }

    @Override
    public void handleActivityResult(int resultCode, int requestCode, Intent data) {
        if (resultCode == -1) {
            Log.d((String)TAG, (String)"handleActivityResult: 1");
            if (requestCode == 200) {
                Log.d((String)TAG, (String)"handleActivityResult: 2");
                this.handlePickedImageResult(data);
            } else if (requestCode == 203) {
                this.handleCroppedImageResult(data);
            }
        } else {
            Log.d((String)TAG, (String)("handleActivityResult: " + resultCode));
            if (resultCode == 204) {
                Log.d((String)TAG, (String)"onActivityResult: Image picker Error");
            }
        }
    }

    private String[] getNeededPermissions() {
        if (this.withCrop) {
            return new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE"};
        }
        return new String[]{"android.permission.CAMERA"};
    }

    private boolean needToAskPermissions() {
        if (this.withCrop) {
            return ContextCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.CAMERA") != 0 || ContextCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.READ_EXTERNAL_STORAGE") != 0;
        }
        return ContextCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.CAMERA") != 0;
    }

    private void handleCroppedImageResult(Intent data) {
        Log.d((String)TAG, (String)"handleCroppedImageResult: ");
        CropImage.ActivityResult result = CropImage.getActivityResult((Intent)data);
        Uri croppedImageUri = result.getUri();
        this.deletePreviouslyCroppedFiles(croppedImageUri);
        this.imageFile = new File(croppedImageUri.getPath());
        this.listener.onImagePicked(croppedImageUri);
    }

    @SuppressLint(value={"NewApi"})
    private void handlePickedImageResult(Intent data) {
        Uri imageUri;
        boolean isCamera = true;
        if (data != null && data.getData() != null) {
            String action = data.getAction();
            isCamera = action != null && action.equals("android.media.action.IMAGE_CAPTURE");
        }
        Uri uri = imageUri = isCamera || data.getData() == null ? this.getCameraFileUri(this.activity) : data.getData();
        if (isCamera) {
            this.deletePreviousCameraFiles();
        }
        Log.d((String)TAG, (String)("handlePickedImageResult: " + imageUri));
        if (this.withCrop) {
            CropImage.activity((Uri)imageUri).setGuidelines(CropImageView.Guidelines.ON).setAspectRatio(this.aspectRatioX, this.aspectRatioY).start(this.activity);
        } else {
            this.imageFile = new File(imageUri.getPath());
            this.listener.onImagePicked(imageUri);
        }
    }

    private void deletePreviousCameraFiles() {
        File imagePath = new File(this.activity.getFilesDir(), "images");
        if (imagePath.exists() && imagePath.isDirectory() && imagePath.listFiles().length > 0) {
            for (File file : imagePath.listFiles()) {
                if (file.getName().equals(currentCameraFileName)) continue;
                file.delete();
            }
        }
    }

    private void deletePreviouslyCroppedFiles(Uri currentCropImageUri) {
        Log.d((String)TAG, (String)("deletePreviouslyCroppedFiles: " + currentCropImageUri));
        String croppedImageName = currentCropImageUri.getLastPathSegment();
        File imagePath = this.activity.getCacheDir();
        Log.d((String)TAG, (String)("deletePreviouslyCroppedFiles: " + imagePath.exists() + " " + imagePath.isDirectory()));
        if (imagePath.exists() && imagePath.isDirectory()) {
            Log.d((String)TAG, (String)("deletePreviouslyCroppedFiles: " + imagePath.toString()));
            Log.d((String)TAG, (String)("deletePreviouslyCroppedFiles: " + imagePath.listFiles().length));
            if (imagePath.listFiles().length > 0) {
                for (File file : imagePath.listFiles()) {
                    Log.d((String)TAG, (String)("deletePreviouslyCroppedFiles: " + file.getName()));
                    if (file.getName().equals(croppedImageName)) continue;
                    file.delete();
                }
            }
        }
    }

    @NonNull
    private Intent getCameraIntent() {
        currentCameraFileName = "outputImage" + System.currentTimeMillis() + ".jpg";
        File imagesDir = new File(this.activity.getFilesDir(), "images");
        imagesDir.mkdirs();
        File file = new File(imagesDir, currentCameraFileName);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"openCamera: coudln't crate ");
            e.printStackTrace();
        }
        Log.d((String)TAG, (String)("openCamera: file exists " + file.exists() + " " + file.toURI().toString()));
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        String authority = this.activity.getPackageName() + ".smart-image-picket-provider";
        Uri outputUri = FileProvider.getUriForFile((Context)this.activity.getApplicationContext(), (String)authority, (File)file);
        cameraIntent.putExtra("output", (Parcelable)outputUri);
        this.activity.grantUriPermission("com.google.android.GoogleCamera", outputUri, 3);
        return cameraIntent;
    }

    private Uri getCameraFileUri(Activity activity) {
        File imagePath = new File(activity.getFilesDir(), "images/" + currentCameraFileName);
        return Uri.fromFile((File)imagePath);
    }

    private void startImagePickerActivity(boolean includeCamera) {
        Intent target;
        ArrayList<Intent> allIntents = new ArrayList<Intent>();
        PackageManager packageManager = this.activity.getPackageManager();
        List galleryIntents = CropImage.getGalleryIntents((PackageManager)packageManager, (String)"android.intent.action.GET_CONTENT", (boolean)false);
        if (galleryIntents.size() == 0) {
            galleryIntents = CropImage.getGalleryIntents((PackageManager)packageManager, (String)"android.intent.action.PICK", (boolean)false);
        }
        if (includeCamera) {
            allIntents.add(this.getCameraIntent());
        }
        allIntents.addAll(galleryIntents);
        if (allIntents.isEmpty()) {
            target = new Intent();
        } else {
            target = (Intent)allIntents.get(allIntents.size() - 1);
            allIntents.remove(allIntents.size() - 1);
        }
        Intent chooserIntent = Intent.createChooser((Intent)target, (CharSequence)this.activity.getString(R.string.select_source));
        chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", allIntents.toArray(new Parcelable[allIntents.size()]));
        this.activity.startActivityForResult(chooserIntent, 200);
    }
}

