/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license;

import com.mycila.maven.plugin.license.AbstractLicenseMojo;
import com.mycila.maven.plugin.license.Report;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.header.Header;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="remove", threadSafe=true)
public final class LicenseRemoveMojo
extends AbstractLicenseMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.report = new Report(this.reportFormat, Report.Action.REMOVE, this.project, this.clock, this.reportSkipped);
        if (!this.skip) {
            this.getLog().info((CharSequence)"Removing license headers...");
        }
        AbstractLicenseMojo.AbstractCallback callback = new AbstractLicenseMojo.AbstractCallback(){

            @Override
            public void onHeaderNotFound(Document document, Header header) {
                LicenseRemoveMojo.this.debug("Header was not found in: %s (But keep trying to find another header to remove)", document.getFile());
                LicenseRemoveMojo.this.remove(document);
            }

            @Override
            public void onExistingHeader(Document document, Header header) {
                LicenseRemoveMojo.this.info("Removing license header from: %s", document.getFile());
                LicenseRemoveMojo.this.remove(document);
            }
        };
        this.execute(callback);
        callback.checkUnknown();
    }

    private void remove(Document document) {
        document.parseHeader();
        if (document.headerDetected()) {
            document.removeHeader();
            if (!this.dryRun) {
                document.save();
            } else {
                String name = document.getFile().getName() + ".licensed";
                File copy = new File(document.getFile().getParentFile(), name);
                this.info("Result saved to: %s", copy);
                document.saveTo(copy);
            }
            this.report.add(document.getFile(), Report.Result.REMOVED);
        } else {
            this.report.add(document.getFile(), Report.Result.NOOP);
        }
    }
}

