/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.boot;

import com.mybatisflex.core.audit.AuditManager;
import com.mybatisflex.core.audit.MessageFactory;
import com.mybatisflex.core.audit.MessageReporter;
import com.mybatisflex.core.audit.http.HttpMessageReporter;
import com.mybatisflex.spring.boot.MybatisFlexAutoConfiguration;
import com.mybatisflex.spring.boot.MybatisFlexProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={MybatisFlexAutoConfiguration.class})
@EnableConfigurationProperties(value={MybatisFlexProperties.class})
@ConditionalOnProperty(prefix="mybatis-flex.admin-config", name={"enable"}, havingValue="true")
public class MybatisFlexAdminAutoConfiguration
implements InitializingBean {
    private final MessageFactory messageFactory;
    private final MybatisFlexProperties properties;
    private final HttpMessageReporter.JSONFormatter jsonFormatter;

    public MybatisFlexAdminAutoConfiguration(ObjectProvider<MessageFactory> messageFactory, ObjectProvider<HttpMessageReporter.JSONFormatter> jsonFormatter, MybatisFlexProperties properties) {
        this.properties = properties;
        this.jsonFormatter = (HttpMessageReporter.JSONFormatter)jsonFormatter.getIfAvailable();
        this.messageFactory = (MessageFactory)messageFactory.getIfAvailable();
    }

    public void afterPropertiesSet() {
        AuditManager.setAuditEnable((boolean)true);
        if (this.messageFactory != null) {
            AuditManager.setMessageFactory((MessageFactory)this.messageFactory);
        }
        MybatisFlexProperties.AdminConfig adminConfig = this.properties.getAdminConfig();
        HttpMessageReporter messageReporter = new HttpMessageReporter(adminConfig.getEndpoint(), adminConfig.getSecretKey(), this.jsonFormatter);
        AuditManager.setMessageReporter((MessageReporter)messageReporter);
    }
}

