/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis;

import com.mybatisflex.core.mybatis.FlexDefaultResultSetHandler;
import com.mybatisflex.core.transaction.TransactionContext;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetWrapper;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandler;

public class FlexResultSetHandler
extends FlexDefaultResultSetHandler {
    public FlexResultSetHandler(Executor executor, MappedStatement mappedStatement, ParameterHandler parameterHandler, ResultHandler<?> resultHandler, BoundSql boundSql, RowBounds rowBounds) {
        super(executor, mappedStatement, parameterHandler, resultHandler, boundSql, rowBounds);
    }

    @Override
    public <E> Cursor<E> handleCursorResultSets(Statement stmt) throws SQLException {
        Cursor defaultCursor = super.handleCursorResultSets(stmt);
        if (TransactionContext.getXID() != null) {
            return new FlexCursor(defaultCursor);
        }
        return defaultCursor;
    }

    @Override
    protected Object createPrimitiveResultObject(ResultSetWrapper rsw, ResultMap resultMap, String columnPrefix) throws SQLException {
        Class resultType = resultMap.getType();
        if (!resultMap.getResultMappings().isEmpty()) {
            List resultMappingList = resultMap.getResultMappings();
            ResultMapping mapping = (ResultMapping)resultMappingList.get(0);
            String columnName = this.prependPrefix(mapping.getColumn(), columnPrefix);
            TypeHandler typeHandler = mapping.getTypeHandler();
            List mappedColumnNames = rsw.getMappedColumnNames(resultMap, columnPrefix);
            if (columnName != null && mappedColumnNames.contains(columnName.toUpperCase(Locale.ENGLISH))) {
                return typeHandler.getResult(rsw.getResultSet(), columnName);
            }
            return null;
        }
        String columnName = (String)rsw.getColumnNames().get(0);
        TypeHandler typeHandler = rsw.getTypeHandler(resultType, columnName);
        return typeHandler.getResult(rsw.getResultSet(), columnName);
    }

    static class FlexCursor<T>
    implements Cursor<T> {
        private final Cursor<T> originalCursor;

        public FlexCursor(Cursor<T> cursor) {
            this.originalCursor = cursor;
            TransactionContext.holdCursor(cursor);
        }

        public void close() {
        }

        public boolean isOpen() {
            return this.originalCursor.isOpen();
        }

        public boolean isConsumed() {
            return this.originalCursor.isConsumed();
        }

        public int getCurrentIndex() {
            return this.originalCursor.getCurrentIndex();
        }

        public Iterator<T> iterator() {
            return this.originalCursor.iterator();
        }
    }
}

