/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.mybatisflex.core.handler.BaseJsonTypeHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;

public class FastjsonTypeHandler
extends BaseJsonTypeHandler<Object> {
    private final Class<?> propertyType;
    private Class<?> genericType;
    private Type type;

    public FastjsonTypeHandler(Class<?> propertyType) {
        this.propertyType = propertyType;
    }

    public FastjsonTypeHandler(Class<?> propertyType, Class<?> genericType) {
        this.propertyType = propertyType;
        this.genericType = genericType;
        this.type = new ParameterizedTypeImpl(propertyType, genericType);
    }

    @Override
    protected Object parseJson(String json) {
        if (this.genericType != null && Collection.class.isAssignableFrom(this.propertyType)) {
            return JSON.parseObject((String)json, (Type)this.type, (Feature[])new Feature[0]);
        }
        return JSON.parseObject((String)json, this.propertyType);
    }

    @Override
    protected String toJson(Object object) {
        return JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty});
    }

    public static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type[] actualTypeArguments;
        private final Type ownerType;
        private final Type rawType;

        public ParameterizedTypeImpl(Type rawType, Type ... actualTypeArguments) {
            this.rawType = rawType;
            this.actualTypeArguments = actualTypeArguments;
            this.ownerType = null;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                ParameterizedTypeImpl that = (ParameterizedTypeImpl)o;
                if (!Arrays.equals(this.actualTypeArguments, that.actualTypeArguments)) {
                    return false;
                }
                if (this.ownerType != null ? this.ownerType.equals(that.ownerType) : that.ownerType == null) {
                    return this.rawType != null ? this.rawType.equals(that.rawType) : that.rawType == null;
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            int result = this.actualTypeArguments != null ? Arrays.hashCode(this.actualTypeArguments) : 0;
            result = 31 * result + (this.ownerType != null ? this.ownerType.hashCode() : 0);
            result = 31 * result + (this.rawType != null ? this.rawType.hashCode() : 0);
            return result;
        }
    }
}

