/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.handler;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import com.mybatisflex.core.handler.BaseJsonTypeHandler;
import java.lang.reflect.Type;
import java.util.Collection;

public class Fastjson2TypeHandler
extends BaseJsonTypeHandler<Object> {
    private final Class<?> propertyType;
    private Class<?> genericType;
    private Type type;

    public Fastjson2TypeHandler(Class<?> propertyType) {
        this.propertyType = propertyType;
    }

    public Fastjson2TypeHandler(Class<?> propertyType, Class<?> genericType) {
        this.propertyType = propertyType;
        this.genericType = genericType;
        this.type = TypeReference.collectionType(propertyType, genericType);
    }

    @Override
    protected Object parseJson(String json) {
        if (this.genericType != null && Collection.class.isAssignableFrom(this.propertyType)) {
            return JSON.parseObject((String)json, (Type)this.type);
        }
        return JSON.parseObject((String)json, this.propertyType);
    }

    @Override
    protected String toJson(Object object) {
        return JSON.toJSONString((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty, JSONWriter.Feature.WriteNullStringAsEmpty});
    }
}

